/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.batching;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.notifications.batch.service.BatchContext;
import com.atlassian.sal.api.user.UserKey;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@ExperimentalSpi
public class CommentContext
implements BatchContext {
    private final UserKey originator;
    private final long commentId;
    private final @Nullable Long parentCommentId;
    private final long pageId;
    private final @Nullable String notificationKey;

    public CommentContext(UserKey originator, long commentId, Optional<Long> parentCommentId, long pageId, Optional<String> notificationKey) {
        this.originator = originator;
        this.commentId = commentId;
        this.parentCommentId = parentCommentId.orElse(null);
        this.pageId = pageId;
        this.notificationKey = notificationKey.orElse(null);
    }

    public long getCommentId() {
        return this.commentId;
    }

    public Optional<Long> optionalParentCommentId() {
        return Optional.ofNullable(this.parentCommentId);
    }

    public long getPageId() {
        return this.pageId;
    }

    public UserKey getOriginator() {
        return this.originator;
    }

    public Optional<String> optionalNotificationKey() {
        return Optional.ofNullable(this.notificationKey);
    }
}

