/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.batching;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.notifications.batch.service.BatchingProcessor;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.confluence.notifications.content.batching.CommentContext;
import com.atlassian.confluence.notifications.content.transformer.SimpleCommentPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@ExperimentalSpi
public class CommentCreatedBatchingProcessor
implements BatchingProcessor<CommentPayload, SimpleCommentPayload, List<CommentContext>> {
    public List<CommentContext> process(CommentPayload payload, List<CommentContext> previousContext) {
        ArrayList<CommentContext> newContext = previousContext == null ? new ArrayList<CommentContext>() : previousContext;
        Optional originator = payload.getOriginatorUserKey();
        CommentContext contextData = new CommentContext(originator.orElse(null), payload.getContentId(), payload.optionalParentCommentId(), payload.getContainerId(), payload.getNotificationKey());
        newContext.add(contextData);
        return newContext;
    }

    public Class<SimpleCommentPayload> getPayloadTypeImpl() {
        return SimpleCommentPayload.class;
    }

    public Class<CommentPayload> getPayloadType() {
        return CommentPayload.class;
    }
}

