/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.confluence.notifications.content.ContentRenderContextFactory;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.user.User;
import io.atlassian.fugue.Maybe;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractCommentCreatedRenderContextFactory
extends ContentRenderContextFactory<CommentPayload> {
    private final ContentService contentService;
    private final LocaleManager localeManager;
    private final NotificationUserService notificationUserService;

    public AbstractCommentCreatedRenderContextFactory(ContentService contentService, NotificationUserService notificationUserService, LocaleManager localeManager) {
        super(CommentPayload.class);
        this.contentService = contentService;
        this.notificationUserService = notificationUserService;
        this.localeManager = localeManager;
    }

    @Override
    protected Optional<NotificationContext> createForRecipient(Notification<CommentPayload> notification, ServerConfiguration serverConfiguration, RoleRecipient recipient) {
        CommentPayload payload = (CommentPayload)notification.getPayload();
        NotificationContext notificationContext = new NotificationContext();
        User recipientUser = this.notificationUserService.findUserForKey(recipient.getUserKey());
        ContentId contentId = ContentId.of((long)payload.getContentId());
        Optional maybeContent = this.contentService.find(this.getMediumSpecificExpansions()).withId(contentId).fetch();
        if (maybeContent.isEmpty()) {
            return Optional.empty();
        }
        User originator = this.notificationUserService.findUserByKey(recipientUser, ((CommentPayload)notification.getPayload()).getOriginatorUserKey());
        Content commentContent = (Content)maybeContent.get();
        Container container = commentContent.getContainer();
        Space space = commentContent.getSpace();
        Maybe<Map<String, Object>> mediumSpecificContext = this.getMediumSpecificContext(notification, serverConfiguration, recipientUser, commentContent);
        if (!mediumSpecificContext.isDefined()) {
            return Optional.empty();
        }
        notificationContext.putAll((Map)mediumSpecificContext.get());
        long messageId = payload.getContainerId() > 0L ? payload.getContainerId() : payload.getContentId();
        notificationContext.put("modifier", (Object)originator);
        notificationContext.put("content", (Object)commentContent);
        notificationContext.put("space", (Object)space);
        notificationContext.put("page", (Object)container);
        notificationContext.put("messageId", (Object)String.valueOf(messageId));
        return Optional.of(notificationContext);
    }

    protected Locale getLocale(User recipientUser) {
        return this.localeManager.getLocale(recipientUser);
    }

    public abstract Expansion[] getMediumSpecificExpansions();

    public abstract Maybe<Map<String, Object>> getMediumSpecificContext(Notification<CommentPayload> var1, ServerConfiguration var2, User var3, Content var4);
}

