/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.MaybeNot;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.content.ContentEditedPayload;
import com.atlassian.confluence.notifications.content.ContentException;
import com.atlassian.confluence.notifications.content.context.MediumSpecificRenderContextProvider;
import com.atlassian.confluence.notifications.content.context.RenderContextProviderFugueTemplate;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractContentEditedRenderContextFactory
extends RenderContextProviderFugueTemplate<ContentEditedPayload>
implements MediumSpecificRenderContextProvider<ContentEditedPayload> {
    private final ContentService contentService;
    private final UserAccessor userAccessor;
    private final NotificationUserService notificationUserService;

    public AbstractContentEditedRenderContextFactory(ContentService contentService, UserAccessor userAccessor, NotificationUserService notificationUserService) {
        super(ContentEditedPayload.class);
        this.contentService = contentService;
        this.userAccessor = userAccessor;
        this.notificationUserService = notificationUserService;
    }

    @Override
    protected Maybe<Map<String, Object>> checkedCreate(Notification<ContentEditedPayload> notification, ServerConfiguration serverConfiguration, Maybe<Either<NotificationAddress, RoleRecipient>> roleRecipient) {
        if (roleRecipient.isEmpty() || ((Either)roleRecipient.get()).isLeft()) {
            return MaybeNot.becauseOf((String)"This factory exposes content, thus recipient has to be provided in order to perform a VIEW permission check.", (Object[])new Object[0]);
        }
        RoleRecipient recipient = (RoleRecipient)((Either)roleRecipient.get()).right().get();
        Preconditions.checkArgument((AuthenticatedUserThreadLocal.get() != null && AuthenticatedUserThreadLocal.get().getKey().equals((Object)recipient.getUserKey()) ? 1 : 0) != 0, (String)"This factory requires the [%s] to be set to the recipient since the [%s] will perform a VIEW permission check in order to provide the content.", AuthenticatedUserThreadLocal.class, ContentService.class);
        NotificationContext notificationContext = new NotificationContext();
        ContentEditedPayload payload = (ContentEditedPayload)notification.getPayload();
        ContentId contentId = ContentId.of((long)payload.getContentId());
        ConfluenceUser recipientUser = this.userAccessor.getExistingUserByKey(recipient.getUserKey());
        User originator = this.notificationUserService.findUserByKey((User)recipientUser, payload.getOriginatorUserKey());
        Optional maybeContent = this.contentService.find(this.getMediumSpecificExpansions()).withId(contentId).fetch();
        if (maybeContent.isEmpty()) {
            return MaybeNot.becauseOfException((Exception)new ContentException("Unable to find content with id [%s], this might be because it does not exist or recipient [%s] does not have VIEW permission.", contentId, recipient.getUserKey()));
        }
        Content content = (Content)maybeContent.get();
        long messageId = payload.getContentId();
        notificationContext.put("messageId", (Object)String.valueOf(messageId));
        notificationContext.put("modifier", (Object)originator);
        notificationContext.put("content", (Object)content);
        Maybe mediumContext = this.getMediumSpecificContext(notification, serverConfiguration, (Either)roleRecipient.get(), content);
        if (!mediumContext.isDefined()) {
            return MaybeNot.becauseOfNoResult((Maybe)mediumContext);
        }
        notificationContext.putAll((Map)mediumContext.get());
        Maybe<Notification.WatchType> watchType = AbstractContentEditedRenderContextFactory.computeWatchTypeFrom(recipient.getRole());
        if (watchType.isDefined()) {
            notificationContext.setWatchType((Notification.WatchType)watchType.get());
        }
        return Option.some((Object)notificationContext.getMap());
    }
}

