/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.notifications.content.ContentException;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.google.common.base.Function;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Optional;

public class ContextFunctionalHelpers {
    public static ToContentFunction toContent(ContentService contentService, String expansionExpression) {
        return new ToContentFunction(expansionExpression, contentService);
    }

    public static ToContentFunction toContent(ContentService contentService, Expansion ... expansionExpression) {
        return new ToContentFunction(expansionExpression, contentService);
    }

    public static AddToContext addToContext(NotificationContext context, String key) {
        return new AddToContext(context, key);
    }

    public static SetWatchType setWatchType(NotificationContext context) {
        return new SetWatchType(context);
    }

    public static <X, Y> Function<Either<X, Y>, Option<X>> toLeft() {
        return input -> input.left().toOption();
    }

    public static <X, Y> Function<Either<X, Y>, Option<Y>> toRight() {
        return input -> input.right().toOption();
    }

    public static class ToContentFunction
    implements Function<Long, Either<ContentException, Content>> {
        private final Expansion[] expansions;
        private final ContentService contentService;

        public ToContentFunction(String expansionExpression, ContentService contentService) {
            this.expansions = ExpansionsParser.parse((String)expansionExpression);
            this.contentService = contentService;
        }

        public ToContentFunction(Expansion[] expansions, ContentService contentService) {
            this.expansions = expansions;
            this.contentService = contentService;
        }

        public Either<ContentException, Content> apply(Long id) {
            if (id == null) {
                return Either.left((Object)new ContentException("Unable to load content - id is null", new Object[0]));
            }
            ContentId contentId = ContentId.of((long)id);
            Optional result = this.contentService.find(this.expansions).withId(contentId).fetch();
            return result.map(Either::right).orElseGet(() -> Either.left((Object)new ContentException("Unable to find content with id %d", id)));
        }
    }

    public static class AddToContext
    implements Effect<Content> {
        private final NotificationContext notificationContext;
        private final String key;

        public AddToContext(NotificationContext notificationContext, String key) {
            this.notificationContext = notificationContext;
            this.key = key;
        }

        public void apply(Content content) {
            this.notificationContext.put(this.key, (Object)content);
        }
    }

    public static class SetWatchType
    implements Effect<Notification.WatchType> {
        private final NotificationContext notificationContext;

        public SetWatchType(NotificationContext notificationContext) {
            this.notificationContext = notificationContext;
        }

        public void apply(Notification.WatchType watchType) {
            this.notificationContext.setWatchType(watchType);
        }
    }
}

