/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context;

import com.atlassian.confluence.core.MaybeNot;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.content.ForgotPasswordPayload;
import com.atlassian.confluence.notifications.content.context.RenderContextProviderFugueTemplate;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ForgotPasswordNotificationRenderContextFactory
extends RenderContextProviderFugueTemplate<ForgotPasswordPayload> {
    private final UserAccessor userAccessor;

    public ForgotPasswordNotificationRenderContextFactory(UserAccessor userAccessor) {
        super(ForgotPasswordPayload.class);
        this.userAccessor = userAccessor;
    }

    @Override
    protected Maybe<Map<String, Object>> checkedCreate(Notification<ForgotPasswordPayload> notification, ServerConfiguration serverConfiguration, Maybe<Either<NotificationAddress, RoleRecipient>> addressData) {
        if (addressData.isEmpty()) {
            return MaybeNot.becauseOfNoResult(addressData);
        }
        if (((Either)addressData.get()).isRight()) {
            return MaybeNot.becauseOf((String)"forgot password notification must be sent to a direct medium, and not the user's preferences", (Object[])new Object[0]);
        }
        HashMap context = Maps.newHashMapWithExpectedSize((int)3);
        ForgotPasswordPayload payload = (ForgotPasswordPayload)notification.getPayload();
        Optional userKey = payload.getOriginatorUserKey();
        ConfluenceUser user = userKey.map(arg_0 -> ((UserAccessor)this.userAccessor).getExistingUserByKey(arg_0)).orElse(null);
        context.put("resetPasswordLink", payload.getResetPasswordLink());
        context.put("forgotPasswordLink", payload.getForgotPasswordLink());
        context.put("user", user);
        return Option.option((Object)context);
    }
}

