/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context.email;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.confluence.notifications.content.CommonContentExpansions;
import com.atlassian.confluence.notifications.content.context.AbstractCommentCreatedRenderContextFactory;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;

@Deprecated
public class EmailCommentCreatedRenderContextFactory
extends AbstractCommentCreatedRenderContextFactory {
    private static final String EMAIL_GATEWAY_CONFIGURATION_NAMESPACE = "email-gateway-configuration";
    private static final String ALLOW_TO_CREATE_COMMENT_BY_EMAIL_KEY = "com.atlassian.confluence.plugins.emailgateway.allow.create.comment";
    private static final Expansion ANCESTOR_HISTORY = ExpansionsParser.parseSingle((String)"ancestors.history");
    private final NotificationUserService notificationUserService;
    private final ContentEntityManager contentEntityManager;
    private final PluginSettingsFactory pluginSettingsFactory;

    public EmailCommentCreatedRenderContextFactory(ContentService contentService, NotificationUserService notificationUserService, LocaleManager localeManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, PluginSettingsFactory pluginSettingsFactory) {
        super(contentService, notificationUserService, localeManager);
        this.notificationUserService = notificationUserService;
        this.contentEntityManager = contentEntityManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public Expansion[] getMediumSpecificExpansions() {
        Expansions ancestorCachedParent = new Expansions(new Expansion[]{CommonContentExpansions.EXPORT_BODY}).prepend("ancestors");
        return new Expansions(new Expansion[]{CommonContentExpansions.SPACE, CommonContentExpansions.EXPORT_BODY, CommonContentExpansions.CONTAINER, CommonContentExpansions.ANCESTORS, ANCESTOR_HISTORY}).merge(ancestorCachedParent).toArray();
    }

    @Override
    public Maybe<Map<String, Object>> getMediumSpecificContext(Notification<CommentPayload> notification, ServerConfiguration serverConfiguration, User recipient, Content content) {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"contentHtml", (Object)((ContentBody)content.getBody().get(ContentRepresentation.EXPORT_VIEW)).getValue());
        if (!content.getAncestors().isEmpty()) {
            Content parent = (Content)content.getAncestors().get(0);
            Person createdBy = parent.getHistory().getCreatedBy();
            User createdByUser = this.notificationUserService.findUserForPerson(recipient, createdBy);
            String parentBodyContent = ((ContentBody)parent.getBody().get(ContentRepresentation.EXPORT_VIEW)).getValue();
            contextBuilder.put((Object)"parentCommentHtml", (Object)parentBodyContent);
            contextBuilder.put((Object)"parentUser", (Object)createdByUser);
            contextBuilder.put((Object)"parentInlineContext", ((CommentPayload)notification.getPayload()).optionalParentInlineContext().orElse(null));
        }
        contextBuilder.putAll(this.buildInlineCommentContext(((CommentPayload)notification.getPayload()).getContentId()));
        boolean replyByEmailEnabled = (Boolean)Optional.ofNullable(this.pluginSettingsFactory.createSettingsForKey(EMAIL_GATEWAY_CONFIGURATION_NAMESPACE).get(ALLOW_TO_CREATE_COMMENT_BY_EMAIL_KEY)).orElse(false);
        contextBuilder.put((Object)"replyByEmailEnabled", (Object)replyByEmailEnabled);
        return Option.some((Object)contextBuilder.build());
    }

    private Map<String, Object> buildInlineCommentContext(long contentId) {
        String originalSelection;
        ContentEntityObject entity = this.contentEntityManager.getById(contentId);
        if (entity != null && Boolean.parseBoolean(entity.getProperties().getStringProperty("inline-comment")) && StringUtils.isNotEmpty((CharSequence)(originalSelection = entity.getProperties().getStringProperty("inline-original-selection")))) {
            return ImmutableMap.of((Object)"inlineContext", (Object)originalSelection);
        }
        return ImmutableMap.of();
    }
}

