/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.context.email;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.content.CommonContentExpansions;
import com.atlassian.confluence.notifications.content.ContentEditedPayload;
import com.atlassian.confluence.notifications.content.DiffContextProvider;
import com.atlassian.confluence.notifications.content.context.AbstractContentEditedRenderContextFactory;
import com.atlassian.confluence.notifications.content.transformer.TransformerUtils;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.sal.api.user.UserKey;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Optional;

public class EmailContentEditedRenderContextFactory
extends AbstractContentEditedRenderContextFactory {
    private final DiffContextProvider diffContextProvider;

    public EmailContentEditedRenderContextFactory(ContentService contentService, UserAccessor userAccessor, NotificationUserService notificationUserService, DiffContextProvider diffContextProvider) {
        super(contentService, userAccessor, notificationUserService);
        this.diffContextProvider = diffContextProvider;
    }

    @Override
    public Expansion[] getMediumSpecificExpansions() {
        return new Expansion[]{CommonContentExpansions.CONTAINER, CommonContentExpansions.SPACE, CommonContentExpansions.VERSION};
    }

    @Override
    public Maybe<Map<String, Object>> getMediumSpecificContext(Notification<ContentEditedPayload> notification, ServerConfiguration serverConfiguration, Either<NotificationAddress, RoleRecipient> roleRecipient, Content content) {
        ContentEditedPayload payload = (ContentEditedPayload)notification.getPayload();
        ContentId currentId = ContentId.of((ContentType)payload.getContentType(), (long)payload.getContentId());
        ContentId originalId = ContentId.of((ContentType)payload.getContentType(), (long)payload.getOriginalId());
        Optional<UserKey> recipient = roleRecipient.right().toOptional().map(TransformerUtils.toUserKey());
        return Option.some(this.diffContextProvider.generateDiffContext(currentId, originalId, recipient));
    }
}

