/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.event.events.content.Contented;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.notifications.content.ContentIdPayload;
import com.atlassian.confluence.notifications.content.transformer.FuguePayloadTransformerTemplate;
import com.atlassian.confluence.notifications.content.transformer.SimpleContentIdPayload;
import com.atlassian.confluence.notifications.content.transformer.TransformerUtils;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;

public class BlogPostCreatedPayloadTransformer
extends FuguePayloadTransformerTemplate<BlogPostEvent, ContentIdPayload> {
    public BlogPostCreatedPayloadTransformer() {
        super(BlogPostEvent.class, ContentIdPayload.class);
    }

    @Override
    protected Maybe<ContentIdPayload> maybeCreate(BlogPostEvent blogPostEvent) {
        if (blogPostEvent.isSuppressNotifications()) {
            return Option.none();
        }
        String lastModifierKey = (String)TransformerUtils.getOriginatingUserForContented((Contented)blogPostEvent).getOrNull();
        SimpleContentIdPayload value = new SimpleContentIdPayload(ContentType.BLOG_POST, blogPostEvent.getBlogPost().getId(), lastModifierKey);
        return Option.some((Object)value);
    }
}

