/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.types.UserDriven;
import com.atlassian.confluence.notifications.content.ContentIdPayload;
import com.atlassian.confluence.notifications.content.transformer.FuguePayloadTransformerTemplate;
import com.atlassian.confluence.notifications.content.transformer.SimpleContentIdPayload;
import com.atlassian.confluence.notifications.content.transformer.TransformerUtils;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;

public class BlogPostTrashedPayloadTransformer
extends FuguePayloadTransformerTemplate<BlogPostTrashedEvent, ContentIdPayload> {
    public BlogPostTrashedPayloadTransformer() {
        super(BlogPostTrashedEvent.class, ContentIdPayload.class);
    }

    @Override
    protected Maybe<ContentIdPayload> maybeCreate(BlogPostTrashedEvent blogPostEvent) {
        if (blogPostEvent.isSuppressNotifications()) {
            return Option.none();
        }
        String lastModifierKey = (String)TransformerUtils.getOriginatingUserForUserDriven((UserDriven)blogPostEvent).getOrNull();
        SimpleContentIdPayload value = new SimpleContentIdPayload(ContentType.BLOG_POST, blogPostEvent.getBlogPost().getId(), lastModifierKey);
        return Option.some((Object)value);
    }
}

