/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.Contented;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.notifications.batch.service.BatchingKey;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.confluence.notifications.content.transformer.ContentIdPayloadTransformerTemplate;
import com.atlassian.confluence.notifications.content.transformer.SimpleCommentPayload;
import com.atlassian.confluence.notifications.content.transformer.TransformerUtils;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Function;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;

public class CommentCreatedPayloadTransformer
extends ContentIdPayloadTransformerTemplate<CommentCreateEvent, CommentPayload> {
    private static final Function<Comment, Long> TO_COMMENT_ID = EntityObject::getId;

    public CommentCreatedPayloadTransformer() {
        super(CommentCreateEvent.class, CommentPayload.class);
    }

    @Override
    public BatchingKey getBatchingColumnValue(CommentPayload payload) {
        return payload == null ? BatchingKey.NO_BATCHING : new BatchingKey(String.valueOf(payload.getContainerId()), payload.getContainerType().getType());
    }

    @Override
    protected Maybe<CommentPayload> maybeCreate(CommentCreateEvent commentCreateEvent) {
        Comment comment = commentCreateEvent.getComment();
        ContentEntityObject container = comment.getContainer();
        if (commentCreateEvent.isSuppressNotifications() || container instanceof Attachment) {
            return Option.none();
        }
        Long parentId = (Long)Option.option((Object)comment.getParent()).map(TO_COMMENT_ID).getOrNull();
        String parentInlineContext = null;
        if (comment.getParent() != null && comment.getParent().getProperties() != null) {
            parentInlineContext = comment.getParent().getProperties().getStringProperty("inline-original-selection");
        }
        String lastModifierKey = (String)TransformerUtils.getOriginatingUserForContented((Contented)commentCreateEvent).getOrNull();
        SimpleCommentPayload payload = new SimpleCommentPayload(comment.getId(), container.getId(), container.getType(), parentId, lastModifierKey);
        payload.setParentInlineContext(parentInlineContext != null ? parentInlineContext : "");
        return Option.some((Object)payload);
    }
}

