/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.confluence.event.events.follow.FollowEvent;
import com.atlassian.confluence.notifications.content.FollowerPayload;
import com.atlassian.confluence.notifications.content.transformer.FuguePayloadTransformerTemplate;
import com.atlassian.confluence.notifications.content.transformer.SimpleFollowerNotificationPayload;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;

public class FollowerPayloadTransformer
extends FuguePayloadTransformerTemplate<FollowEvent, FollowerPayload> {
    private final UserAccessor userAccessor;
    private final ConfluenceAccessManager confluenceAccessManager;

    public FollowerPayloadTransformer(UserAccessor userAccessor, ConfluenceAccessManager confluenceAccessManager) {
        super(FollowEvent.class, FollowerPayload.class);
        this.userAccessor = userAccessor;
        this.confluenceAccessManager = confluenceAccessManager;
    }

    @Override
    protected Maybe<FollowerPayload> maybeCreate(FollowEvent followEvent) {
        if (this.isNotificationRequired(followEvent.getFolloweeUser())) {
            SimpleFollowerNotificationPayload payload = new SimpleFollowerNotificationPayload(followEvent.getFolloweeUser().getKey().getStringValue(), followEvent.getFollowerUser().getKey().getStringValue());
            return Option.some((Object)payload);
        }
        return Option.none();
    }

    private boolean isNotificationRequired(ConfluenceUser subject) {
        return this.userAccessor.getUserPreferences(subject).getBoolean("confluence.prefs.notify.on.new.followers").orElse(false) != false && this.confluenceAccessManager.getUserAccessStatus(subject).hasLicensedAccess();
    }
}

