/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.notifications.content.ContentEditedPayload;
import com.atlassian.confluence.notifications.content.transformer.SimpleContentIdPayload;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

@ExperimentalApi
public class SimpleContentEditedPayload
extends SimpleContentIdPayload
implements ContentEditedPayload {
    private final long originalId;
    private final String inlineContext;

    public SimpleContentEditedPayload() {
        super(null, 0L, null);
        this.originalId = 0L;
        this.inlineContext = null;
    }

    @JsonCreator
    public SimpleContentEditedPayload(@JsonProperty(value="contentType") ContentType contentType, @JsonProperty(value="contentId") long contentId, @JsonProperty(value="originalId") long originalId, @JsonProperty(value="originatingUserKey") String originatingUserKey, @JsonProperty(value="inlineContext") String inlineContext) {
        super(contentType, contentId, originatingUserKey);
        this.originalId = originalId;
        this.inlineContext = inlineContext;
    }

    @Override
    public long getOriginalId() {
        return this.originalId;
    }

    @Override
    public Optional<String> optionalInlineContext() {
        return Optional.ofNullable(this.inlineContext);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleContentEditedPayload{");
        sb.append("originalId=").append(this.originalId);
        sb.append(", inlineContext=").append(this.inlineContext);
        sb.append("; ").append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

