/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.notifications.content.ContentIdPayload;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class SimpleContentIdPayload
implements ContentIdPayload {
    private final long contentId;
    private final ContentType contentType;
    private final String originatingUserKey;
    private String notificationKey;

    public SimpleContentIdPayload() {
        this.contentType = null;
        this.contentId = 0L;
        this.originatingUserKey = null;
    }

    @JsonCreator
    public SimpleContentIdPayload(@JsonProperty(value="contentType") ContentType contentType, @JsonProperty(value="contentId") long contentId, @JsonProperty(value="originatingUserKey") String originatingUserKey) {
        this.contentType = contentType;
        this.contentId = contentId;
        this.originatingUserKey = originatingUserKey;
    }

    @Override
    public long getContentId() {
        return this.contentId;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return StringUtils.isEmpty((CharSequence)this.originatingUserKey) ? Optional.empty() : Optional.of(new UserKey(this.originatingUserKey));
    }

    public void setNotificationKey(String notificationKey) {
        this.notificationKey = notificationKey;
    }

    public Optional<String> getNotificationKey() {
        return Optional.ofNullable(this.notificationKey);
    }

    public String toString() {
        return "SimpleContentIdPayload{contentId=" + this.contentId + ", contentType=" + String.valueOf(this.contentType) + ", originatingUserKey='" + this.originatingUserKey + "'}";
    }
}

