/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.notifications.content.FollowerPayload;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class SimpleFollowerNotificationPayload
implements FollowerPayload {
    private final String userBeingFollowed;
    private final String follower;

    @JsonCreator
    public SimpleFollowerNotificationPayload(@JsonProperty(value="userBeingFollowed") String userBeingFollowed, @JsonProperty(value="follower") String follower) {
        this.userBeingFollowed = userBeingFollowed;
        this.follower = follower;
    }

    @Override
    public String getFollower() {
        return this.follower;
    }

    @Override
    public String getUserBeingFollowed() {
        return this.userBeingFollowed;
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return StringUtils.isEmpty((CharSequence)this.follower) ? Optional.empty() : Optional.of(new UserKey(this.follower));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleFollowerNotificationPayload{");
        sb.append("userBeingFollowed='").append(this.userBeingFollowed).append('\'');
        sb.append(", follower='").append(this.follower).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

