/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.transformer;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.notifications.content.ForgotPasswordPayload;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class SimpleForgotPasswordPayload
implements ForgotPasswordPayload {
    private final String userKey;
    private final String resetPasswordLink;
    private final String forgotPasswordLink;

    public SimpleForgotPasswordPayload() {
        this.userKey = null;
        this.resetPasswordLink = null;
        this.forgotPasswordLink = null;
    }

    @JsonCreator
    public SimpleForgotPasswordPayload(@JsonProperty(value="userKey") String userKey, @JsonProperty(value="resetPasswordLink") String resetPasswordLink, @JsonProperty(value="forgotPasswordLink") String forgotPasswordLink) {
        this.userKey = userKey;
        this.resetPasswordLink = resetPasswordLink;
        this.forgotPasswordLink = forgotPasswordLink;
    }

    @Override
    public String getResetPasswordLink() {
        return this.resetPasswordLink;
    }

    @Override
    public String getForgotPasswordLink() {
        return this.forgotPasswordLink;
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return StringUtils.isEmpty((CharSequence)this.userKey) ? Optional.empty() : Optional.of(new UserKey(this.userKey));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleForgotPasswordPayload{");
        sb.append("userKey='").append(this.userKey).append('\'');
        sb.append(", resetPasswordLink='").append(this.resetPasswordLink).append('\'');
        sb.append(", forgotPasswordLink='").append(this.forgotPasswordLink).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

