/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.dashboard.rest;

import com.atlassian.confluence.plugins.macros.dashboard.GlobalEntitiesContextProvider;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.velocity.ConfluenceStaticContextItemProvider;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

@AnonymousSiteAccess
@Path(value="/global-entities")
public class GlobalEntitiesResource {
    public static final String TEMPLATE_PATH = "com/atlassian/confluence/plugins/macros/dashboard/";
    private final TemplateRenderer templateRenderer;
    private final GlobalEntitiesContextProvider globalEntitiesContextProvider;
    private final ConfluenceStaticContextItemProvider confluenceStaticContextItemProvider;
    private final DarkFeaturesManager darkFeaturesManager;

    @Inject
    public GlobalEntitiesResource(@ComponentImport TemplateRenderer templateRenderer, GlobalEntitiesContextProvider globalEntitiesContextProvider, @ComponentImport DarkFeaturesManager darkFeaturesManager) {
        this.templateRenderer = templateRenderer;
        this.globalEntitiesContextProvider = globalEntitiesContextProvider;
        this.darkFeaturesManager = darkFeaturesManager;
        this.confluenceStaticContextItemProvider = new ConfluenceStaticContextItemProvider();
    }

    @GET
    @Path(value="spaces")
    public Response spaces(@Context HttpServletRequest httpRequest) throws IOException {
        Map<String, Object> context = this.buildInitialContext(httpRequest);
        this.globalEntitiesContextProvider.injectSpaceTabContext(AuthenticatedUserThreadLocal.get(), context);
        return Response.ok((Object)this.renderEntitiesTemplate(context, "spaces")).header("Content-Type", (Object)"text/html; charset=UTF-8").build();
    }

    @GET
    @Path(value="pages")
    public Response pages(@Context HttpServletRequest httpRequest) throws IOException {
        Map<String, Object> context = this.buildInitialContext(httpRequest);
        this.globalEntitiesContextProvider.injectPagesTabContext(context);
        return Response.ok((Object)this.renderEntitiesTemplate(context, "pages")).header("Content-Type", (Object)"text/html; charset=UTF-8").build();
    }

    @GET
    @Path(value="network")
    public Response network(@Context HttpServletRequest httpRequest) {
        Map<String, Object> context = this.buildInitialContext(httpRequest);
        return Response.ok((Object)this.renderEntitiesTemplate(context, "network")).header("Content-Type", (Object)"text/html; charset=UTF-8").build();
    }

    private Map<String, Object> buildInitialContext(HttpServletRequest httpRequest) {
        HashMap context = Maps.newHashMap();
        context.putAll(this.confluenceStaticContextItemProvider.getContextMap());
        context.put("helper", new GlobalHelper());
        context.put("request", httpRequest);
        context.put("darkFeatures", this.darkFeaturesManager.getDarkFeatures());
        context.put("authenticatedUser", AuthenticatedUserThreadLocal.get());
        return context;
    }

    private String renderEntitiesTemplate(Map<String, Object> context, String entityName) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.templateRenderer.render(TEMPLATE_PATH + entityName + "-entities.vm", context, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

