/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.core.spi.service.AuditMethodProvider;
import com.atlassian.audit.core.spi.service.BaseUrlProvider;
import com.atlassian.audit.core.spi.service.ClusterNodeProvider;
import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.config.imports.BitbucketImportServiceConfig;
import com.atlassian.lighthouse.config.imports.CoreImportServiceConfig;
import com.atlassian.lighthouse.config.system.BitbucketSystemPropertyProvider;
import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.config.system.SystemPropertyProvider;
import com.atlassian.lighthouse.database.transactions.ActiveObjectsTransactionHandler;
import com.atlassian.lighthouse.database.transactions.TransactionHandler;
import com.atlassian.lighthouse.eventlisteners.BitbucketGroupChangeListener;
import com.atlassian.lighthouse.eventlisteners.UserDetailsChangeListener;
import com.atlassian.lighthouse.eventlisteners.UserDirectoryModificationListener;
import com.atlassian.lighthouse.matchers.audit.log.BitbucketAuditingMatchers;
import com.atlassian.lighthouse.matchers.audit.log.GlobalAuditingMatchers;
import com.atlassian.lighthouse.matchers.audit.log.SharedAuditingMatchers;
import com.atlassian.lighthouse.notification.generators.BitbucketMailMessageFactory;
import com.atlassian.lighthouse.notification.generators.DefaultEmailFactory;
import com.atlassian.lighthouse.notification.mail.BitbucketMailService;
import com.atlassian.lighthouse.notification.mail.MailServiceInterface;
import com.atlassian.lighthouse.notification.template.MailTemplateRenderer;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.ChangedValuesDetector;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.DefaultThreatDetector;
import com.atlassian.lighthouse.security.detector.GroupPermissionChangedDetector;
import com.atlassian.lighthouse.security.detector.ThreatDetector;
import com.atlassian.lighthouse.security.detector.UserDeletedDetector;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.service.DefaultThreatEventEntityFactory;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.bitbucket.BitbucketAuditMethodProvider;
import com.atlassian.lighthouse.service.bitbucket.BitbucketBaseUrlProvider;
import com.atlassian.lighthouse.service.bitbucket.BitbucketClusterNodeProvider;
import com.atlassian.lighthouse.service.bitbucket.BitbucketCurrentUserProvider;
import com.atlassian.lighthouse.service.bitbucket.BitbucketIpAddressProvider;
import com.atlassian.lighthouse.service.event.EventToThreatsService;
import com.atlassian.lighthouse.service.group.AdminChangeHandler;
import com.atlassian.lighthouse.service.group.BitbucketGroupChangeHandler;
import com.atlassian.lighthouse.service.group.cache.BitbucketCachedAdminGroupUpdater;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import com.atlassian.lighthouse.service.group.supplier.BitbucketAdminGroupNamesFinder;
import com.atlassian.lighthouse.service.user.BitbucketSecurityUserService;
import com.atlassian.lighthouse.service.user.BitbucketUserDetailsFinder;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.lighthouse.service.user.cache.BitbucketCachedAdminUserUpdater;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import com.atlassian.lighthouse.service.user.supplier.AdminUsernamesFinder;
import com.atlassian.lighthouse.service.user.supplier.BitbucketAdminUsernamesFinder;
import com.atlassian.lighthouse.usage.service.NoOpUserReferenceProvider;
import com.atlassian.lighthouse.usage.service.UserReferenceProvider;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CoreImportServiceConfig.class, BitbucketImportServiceConfig.class})
@Conditional(value={BitbucketOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J<\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0017J \u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J\u001a\u0010+\u001a\u00020,2\b\b\u0001\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0017J \u00100\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J$\u00101\u001a\u0002022\b\b\u0001\u0010-\u001a\u00020&2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0017J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0017J2\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010-\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0017J \u0010;\u001a\u00020<2\u0006\u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u000208H\u0017J\u0010\u0010=\u001a\u00020>2\u0006\u00105\u001a\u000206H\u0017J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010=\u001a\u00020>H\u0017J:\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D2\b\b\u0001\u0010-\u001a\u00020&2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010H\u001a\u00020IH\u0017J(\u0010J\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010J\u001a\u00020K2\u0006\u0010)\u001a\u00020*2\u0006\u0010H\u001a\u00020IH\u0017J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0017J\u0018\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010T\u001a\u00020U2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0017J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020Z2\u0006\u0010L\u001a\u00020[2\u0006\u0010P\u001a\u00020\\2\u0006\u0010T\u001a\u00020]2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J \u0010^\u001a\u00020_2\u0006\u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u0010`\u001a\u00020\bH\u0017J \u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\u0006\u0010H\u001a\u00020I2\u0006\u0010e\u001a\u00020KH\u0017J(\u0010f\u001a\u00020g2\u0006\u00109\u001a\u00020:2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010h\u001a\u00020iH\u0017\u00a8\u0006j"}, d2={"Lcom/atlassian/lighthouse/config/BitbucketBeanConfig;", "", "()V", "activeObjectsTransactionHandler", "Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;", "activeObjects", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "adminDetailsChangeHandler", "Lcom/atlassian/lighthouse/service/group/AdminChangeHandler;", "adminUsernamesFinder", "Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "cachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "eventToThreatsService", "Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "threatEventEntityFactory", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "auditMethodProvider", "Lcom/atlassian/audit/core/spi/service/AuditMethodProvider;", "osgiContainerManager", "Lcom/atlassian/plugin/osgi/container/OsgiContainerManager;", "requestManager", "Lcom/atlassian/bitbucket/request/RequestManager;", "baseUrlProvider", "Lcom/atlassian/lighthouse/service/bitbucket/BitbucketBaseUrlProvider;", "navBuilder", "Lcom/atlassian/bitbucket/nav/NavBuilder;", "bitbucketAdminGroupNamesFinder", "Lcom/atlassian/lighthouse/service/group/supplier/BitbucketAdminGroupNamesFinder;", "permissionService", "Lcom/atlassian/bitbucket/permission/PermissionService;", "bitbucketAdminUsernamesFinder", "Lcom/atlassian/lighthouse/service/user/supplier/BitbucketAdminUsernamesFinder;", "bitbucketCachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "bitbucketCachedAdminGroupUpdater", "Lcom/atlassian/lighthouse/service/group/cache/BitbucketCachedAdminGroupUpdater;", "cachedAdminGroupService", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "bitbucketCachedAdminUserService", "bitbucketCachedAdminUserUpdater", "Lcom/atlassian/lighthouse/service/user/cache/BitbucketCachedAdminUserUpdater;", "bitbucketEmailFactory", "Lcom/atlassian/lighthouse/notification/generators/DefaultEmailFactory;", "mailTemplateRenderer", "Lcom/atlassian/lighthouse/notification/template/MailTemplateRenderer;", "bitbucketGroupChangeHandler", "Lcom/atlassian/lighthouse/service/group/BitbucketGroupChangeHandler;", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "bitbucketGroupChangeListener", "Lcom/atlassian/lighthouse/eventlisteners/BitbucketGroupChangeListener;", "bitbucketMailMessageFactory", "Lcom/atlassian/lighthouse/notification/generators/BitbucketMailMessageFactory;", "bitbucketMailService", "Lcom/atlassian/lighthouse/notification/mail/MailServiceInterface;", "mailService", "Lcom/atlassian/bitbucket/mail/MailService;", "bitbucketThreatDetectors", "", "Lcom/atlassian/lighthouse/security/detector/ThreatDetector;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "bitbucketUserService", "Lcom/atlassian/bitbucket/user/UserService;", "clusterNodeProvider", "Lcom/atlassian/lighthouse/service/bitbucket/BitbucketClusterNodeProvider;", "clusterService", "Lcom/atlassian/bitbucket/cluster/ClusterService;", "currentUserProvider", "Lcom/atlassian/lighthouse/service/bitbucket/BitbucketCurrentUserProvider;", "authenticationContext", "Lcom/atlassian/bitbucket/auth/AuthenticationContext;", "ipAddressProvider", "Lcom/atlassian/lighthouse/service/bitbucket/BitbucketIpAddressProvider;", "systemPropertyProvider", "Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;", "applicationPropertiesService", "Lcom/atlassian/bitbucket/server/ApplicationPropertiesService;", "Lcom/atlassian/audit/core/spi/service/BaseUrlProvider;", "Lcom/atlassian/audit/core/spi/service/ClusterNodeProvider;", "Lcom/atlassian/audit/core/spi/service/CurrentUserProvider;", "Lcom/atlassian/audit/core/spi/service/IpAddressProvider;", "userDetailsChangeListener", "Lcom/atlassian/lighthouse/eventlisteners/UserDetailsChangeListener;", "adminChangeHandler", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "userService", "userDirectoryModificationListener", "Lcom/atlassian/lighthouse/eventlisteners/UserDirectoryModificationListener;", "userReferenceProvider", "Lcom/atlassian/lighthouse/usage/service/UserReferenceProvider;", "atlassian-lighthouse-core"})
public class BitbucketBeanConfig {
    @Bean(value={"transactionHandler"})
    @NotNull
    public TransactionHandler activeObjectsTransactionHandler(@NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter(activeObjects, "activeObjects");
        return new ActiveObjectsTransactionHandler(activeObjects);
    }

    @Bean
    @NotNull
    public BitbucketAdminGroupNamesFinder bitbucketAdminGroupNamesFinder(@NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter(permissionService, "permissionService");
        return new BitbucketAdminGroupNamesFinder(permissionService);
    }

    @Bean
    @NotNull
    public BitbucketAdminUsernamesFinder bitbucketAdminUsernamesFinder(@NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter(permissionService, "permissionService");
        return new BitbucketAdminUsernamesFinder(permissionService);
    }

    @Bean(value={"bitbucketCachedAdminGroupService"})
    @NotNull
    public CachedAdminGroupService bitbucketCachedAdminGroupService(@NotNull BitbucketAdminGroupNamesFinder bitbucketAdminGroupNamesFinder, @NotNull CacheManager cacheManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(bitbucketAdminGroupNamesFinder, "bitbucketAdminGroupNamesFinder");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new CachedAdminGroupService(bitbucketAdminGroupNamesFinder, cacheManager, lighthouseConfig.getAdminGroupCacheRefreshRate());
    }

    @Bean(value={"bitbucketCachedAdminUserService"})
    @NotNull
    public CachedAdminUserService bitbucketCachedAdminUserService(@NotNull BitbucketAdminUsernamesFinder bitbucketAdminUsernamesFinder, @NotNull CacheManager cacheManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(bitbucketAdminUsernamesFinder, "bitbucketAdminUsernamesFinder");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new CachedAdminUserService(bitbucketAdminUsernamesFinder, cacheManager, lighthouseConfig.getAdminUserCacheRefreshRate());
    }

    @Bean(value={"bitbucketCachedAdminGroupUpdater"})
    @NotNull
    public BitbucketCachedAdminGroupUpdater bitbucketCachedAdminGroupUpdater(@Qualifier(value="bitbucketCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        return new BitbucketCachedAdminGroupUpdater(cachedAdminGroupService, eventPublisher);
    }

    @Bean(value={"bitbucketCachedAdminUserUpdater"})
    @NotNull
    public BitbucketCachedAdminUserUpdater bitbucketCachedAdminUserUpdater(@Qualifier(value="bitbucketCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @Qualifier(value="bitbucketCachedAdminUserService") @NotNull CachedAdminUserService cachedAdminUserService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        return new BitbucketCachedAdminUserUpdater(cachedAdminGroupService, cachedAdminUserService, eventPublisher);
    }

    @Bean
    @NotNull
    public AuditMethodProvider auditMethodProvider(@NotNull OsgiContainerManager osgiContainerManager, @NotNull RequestManager requestManager) {
        Intrinsics.checkNotNullParameter(osgiContainerManager, "osgiContainerManager");
        Intrinsics.checkNotNullParameter(requestManager, "requestManager");
        return new BitbucketAuditMethodProvider(osgiContainerManager, requestManager);
    }

    @Bean
    @NotNull
    public BitbucketBaseUrlProvider baseUrlProvider(@NotNull NavBuilder navBuilder) {
        Intrinsics.checkNotNullParameter(navBuilder, "navBuilder");
        return new BitbucketBaseUrlProvider(navBuilder);
    }

    @Bean
    @NotNull
    public BitbucketClusterNodeProvider clusterNodeProvider(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter(clusterService, "clusterService");
        return new BitbucketClusterNodeProvider(clusterService);
    }

    @Bean
    @NotNull
    public BitbucketCurrentUserProvider currentUserProvider(@NotNull AuthenticationContext authenticationContext, @NotNull RequestManager requestManager) {
        Intrinsics.checkNotNullParameter(authenticationContext, "authenticationContext");
        Intrinsics.checkNotNullParameter(requestManager, "requestManager");
        return new BitbucketCurrentUserProvider(authenticationContext, requestManager);
    }

    @Bean
    @NotNull
    public BitbucketIpAddressProvider ipAddressProvider(@NotNull RequestManager requestManager) {
        Intrinsics.checkNotNullParameter(requestManager, "requestManager");
        return new BitbucketIpAddressProvider(requestManager);
    }

    @Bean
    @NotNull
    public ThreatEventEntityFactory threatEventEntityFactory(@NotNull AuditMethodProvider auditMethodProvider, @NotNull BaseUrlProvider baseUrlProvider, @NotNull ClusterNodeProvider clusterNodeProvider, @NotNull CurrentUserProvider currentUserProvider, @NotNull IpAddressProvider ipAddressProvider, @NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(auditMethodProvider, "auditMethodProvider");
        Intrinsics.checkNotNullParameter(baseUrlProvider, "baseUrlProvider");
        Intrinsics.checkNotNullParameter(clusterNodeProvider, "clusterNodeProvider");
        Intrinsics.checkNotNullParameter(currentUserProvider, "currentUserProvider");
        Intrinsics.checkNotNullParameter(ipAddressProvider, "ipAddressProvider");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        return new DefaultThreatEventEntityFactory(auditMethodProvider, baseUrlProvider, clusterNodeProvider, currentUserProvider, ipAddressProvider, securityUserService, null, 64, null);
    }

    @Bean
    @NotNull
    public BitbucketGroupChangeListener bitbucketGroupChangeListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull EventPublisher eventPublisher, @NotNull BitbucketGroupChangeHandler bitbucketGroupChangeHandler) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(bitbucketGroupChangeHandler, "bitbucketGroupChangeHandler");
        return new BitbucketGroupChangeListener(alertDeactivationService, eventPublisher, bitbucketGroupChangeHandler);
    }

    @Bean
    @NotNull
    public BitbucketGroupChangeHandler bitbucketGroupChangeHandler(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @NotNull ThreatEventEntityFactory threatEventEntityFactory, @Qualifier(value="bitbucketCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(threatEventEntityFactory, "threatEventEntityFactory");
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new BitbucketGroupChangeHandler(alertDeactivationService, alertService, threatEventEntityFactory, cachedAdminGroupService, "ADMIN", "SYS_ADMIN", lighthouseConfig.getSecurityGroupName());
    }

    @Bean(value={"mailServiceInterface"})
    @NotNull
    public MailServiceInterface bitbucketMailService(@NotNull MailService mailService, @NotNull BitbucketMailMessageFactory bitbucketMailMessageFactory) {
        Intrinsics.checkNotNullParameter(mailService, "mailService");
        Intrinsics.checkNotNullParameter(bitbucketMailMessageFactory, "bitbucketMailMessageFactory");
        return new BitbucketMailService(mailService, bitbucketMailMessageFactory);
    }

    @Bean
    @NotNull
    public DefaultEmailFactory bitbucketEmailFactory(@NotNull MailTemplateRenderer mailTemplateRenderer) {
        Intrinsics.checkNotNullParameter(mailTemplateRenderer, "mailTemplateRenderer");
        return new DefaultEmailFactory(mailTemplateRenderer);
    }

    @Bean
    @NotNull
    public BitbucketMailMessageFactory bitbucketMailMessageFactory(@NotNull MailTemplateRenderer mailTemplateRenderer) {
        Intrinsics.checkNotNullParameter(mailTemplateRenderer, "mailTemplateRenderer");
        return new BitbucketMailMessageFactory(mailTemplateRenderer);
    }

    @Bean(value={"threatDetectors"})
    @NotNull
    public List<ThreatDetector> bitbucketThreatDetectors(@Qualifier(value="bitbucketCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @Qualifier(value="bitbucketCachedAdminUserService") @NotNull CachedAdminUserService cachedAdminUserService, @NotNull CommonDetectionFunctions commonDetectionFunctions, @NotNull SecurityUserService securityUserService, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        DefaultThreatDetector[] defaultThreatDetectorArray = new DefaultThreatDetector[]{new GroupPermissionChangedDetector(AlertType.ADMIN_GROUP_DELETED, BitbucketAuditingMatchers.ADMIN_GROUP_DELETED, "ADMIN", cachedAdminGroupService, commonDetectionFunctions, "SYS_ADMIN"), new DefaultThreatDetector(AlertType.ADMIN_GROUP_PERMISSION_ADDED, BitbucketAuditingMatchers.ADMIN_GROUP_PERMISSION_GRANTED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_GROUP_PERMISSION_ADDED, BitbucketAuditingMatchers.ADMIN_GROUP_PERMISSION_ELEVATED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_GROUP_PERMISSION_DELETED, BitbucketAuditingMatchers.ADMIN_GROUP_PERMISSION_DEMOTED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_GROUP_PERMISSION_DELETED, BitbucketAuditingMatchers.ADMIN_GROUP_PERMISSION_REVOKED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_USER_PERMISSION_ADDED, BitbucketAuditingMatchers.ADMIN_USER_PERMISSION_GRANTED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_USER_PERMISSION_ADDED, BitbucketAuditingMatchers.ADMIN_USER_PERMISSION_ELEVATED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_USER_PERMISSION_DELETED, BitbucketAuditingMatchers.ADMIN_USER_PERMISSION_DEMOTED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_USER_PERMISSION_DELETED, BitbucketAuditingMatchers.ADMIN_USER_PERMISSION_REVOKED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.AUDITING_CONFIG_MODIFIED, SharedAuditingMatchers.AUDITING_CONFIG_MODIFIED_MATCHER, commonDetectionFunctions), new DefaultThreatDetector(AlertType.APP_INSTALLED, BitbucketAuditingMatchers.APP_INSTALLED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.CONFIGURATION_CHANGED, BitbucketAuditingMatchers.GENERAL_CONFIGURATION_CHANGED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.CONFIGURATION_CHANGED, BitbucketAuditingMatchers.SECURITY_CONFIGURATION_CHANGED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.CONFIGURATION_CHANGED, BitbucketAuditingMatchers.SSH_CONFIGURATION_CHANGED, commonDetectionFunctions), new UserDeletedDetector(AlertType.ADMIN_USER_DELETED, BitbucketAuditingMatchers.ADMIN_USER_DELETED, "ADMIN", cachedAdminUserService, commonDetectionFunctions, "SYS_ADMIN"), new DefaultThreatDetector(AlertType.ANNOUNCEMENT_BANNER_ADDED, BitbucketAuditingMatchers.ANNOUNCEMENT_BANNER_ADDED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ANNOUNCEMENT_BANNER_DELETED, BitbucketAuditingMatchers.ANNOUNCEMENT_BANNER_DELETED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.ANNOUNCEMENT_BANNER_UPDATED, BitbucketAuditingMatchers.ANNOUNCEMENT_BANNER_UPDATED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.AUTHENTICATION_METHOD_ADDED, GlobalAuditingMatchers.AUTHENTICATION_METHOD_ADDED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.AUTHENTICATION_METHOD_DELETED, GlobalAuditingMatchers.AUTHENTICATION_METHOD_DELETED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.AUTHENTICATION_METHOD_MODIFIED, GlobalAuditingMatchers.AUTHENTICATION_METHOD_MODIFIED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.BASIC_AUTHENTICATION_CONFIGURATION_DISABLED, GlobalAuditingMatchers.BASIC_AUTHENTICATION_CONFIGURATION_DISABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.BASIC_AUTHENTICATION_CONFIGURATION_ENABLED, GlobalAuditingMatchers.BASIC_AUTHENTICATION_CONFIGURATION_ENABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.LOGGING_ENABLED, BitbucketAuditingMatchers.LOGGING_SETTING_ENABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.LOGGING_DISABLED, BitbucketAuditingMatchers.LOGGING_SETTING_DISABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.PROFILING_ENABLED, BitbucketAuditingMatchers.PROFILING_SETTING_ENABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.PROFILING_DISABLED, BitbucketAuditingMatchers.PROFILING_SETTING_DISABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_USER_LOGGED_IN_WITHOUT_2SV, BitbucketAuditingMatchers.ADMIN_USER_LOGGED_IN_WITHOUT_2SV, commonDetectionFunctions)};
        return CollectionsKt.listOf(defaultThreatDetectorArray);
    }

    @Bean(value={"userService"})
    @NotNull
    public SecurityUserService bitbucketUserService(@NotNull PermissionService permissionService, @NotNull UserService bitbucketUserService, @NotNull LighthouseConfig lighthouseConfig, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(permissionService, "permissionService");
        Intrinsics.checkNotNullParameter(bitbucketUserService, "bitbucketUserService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        return new BitbucketSecurityUserService(permissionService, lighthouseConfig.getSecurityGroupName(), bitbucketUserService, userManager);
    }

    @Bean
    @NotNull
    public AdminChangeHandler adminDetailsChangeHandler(@Qualifier(value="bitbucketAdminUsernamesFinder") @NotNull AdminUsernamesFinder adminUsernamesFinder, @NotNull AlertService alertService, @Qualifier(value="bitbucketCachedAdminUserService") @NotNull CachedAdminUserService cachedAdminUserService, @NotNull EventToThreatsService eventToThreatsService, @NotNull ThreatEventEntityFactory threatEventEntityFactory, @NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(adminUsernamesFinder, "adminUsernamesFinder");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        Intrinsics.checkNotNullParameter(threatEventEntityFactory, "threatEventEntityFactory");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        return new AdminChangeHandler(adminUsernamesFinder, alertService, cachedAdminUserService, eventToThreatsService, threatEventEntityFactory, false);
    }

    @Bean
    @NotNull
    public UserDetailsChangeListener userDetailsChangeListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull EventPublisher eventPublisher, @NotNull AdminChangeHandler adminChangeHandler) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(adminChangeHandler, "adminChangeHandler");
        return new UserDetailsChangeListener(alertDeactivationService, eventPublisher, adminChangeHandler);
    }

    @Bean
    @NotNull
    public UserDirectoryModificationListener userDirectoryModificationListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @NotNull EventPublisher eventPublisher, @NotNull EventToThreatsService eventToThreatsService) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        return new UserDirectoryModificationListener(alertDeactivationService, alertService, eventPublisher, eventToThreatsService);
    }

    @Bean
    @NotNull
    public UserDetailsFinder userDetailsFinder(@NotNull I18nResolver i18nResolver, @NotNull UserManager userManager, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(userService, "userService");
        return new BitbucketUserDetailsFinder(i18nResolver, userManager, userService);
    }

    @Bean
    @NotNull
    public UserReferenceProvider userReferenceProvider() {
        return new NoOpUserReferenceProvider();
    }

    @Bean
    @NotNull
    public SystemPropertyProvider systemPropertyProvider(@NotNull ApplicationPropertiesService applicationPropertiesService) {
        Intrinsics.checkNotNullParameter(applicationPropertiesService, "applicationPropertiesService");
        return new BitbucketSystemPropertyProvider(applicationPropertiesService);
    }
}

