/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.audit.api.AuditService;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.config.imports.CoreImportServiceConfig;
import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.config.system.PropertyHelper;
import com.atlassian.lighthouse.config.system.SystemPropertyProvider;
import com.atlassian.lighthouse.database.dao.AlertDao;
import com.atlassian.lighthouse.database.dao.AlertManager;
import com.atlassian.lighthouse.database.dao.AlertStatisticsManager;
import com.atlassian.lighthouse.database.dao.CachingUserAlertStatusCountsManager;
import com.atlassian.lighthouse.database.dao.ScheduleJobDao;
import com.atlassian.lighthouse.database.dao.ScheduleJobManager;
import com.atlassian.lighthouse.database.dao.ThreatEventDao;
import com.atlassian.lighthouse.database.mapper.AlertEntityMapper;
import com.atlassian.lighthouse.database.mapper.ScheduleJobEntityMapper;
import com.atlassian.lighthouse.database.mapper.ThreatEntityMapper;
import com.atlassian.lighthouse.database.transactions.TransactionHandler;
import com.atlassian.lighthouse.i18n.EmailAlertTypeI18nMapper;
import com.atlassian.lighthouse.notification.AuditNotificationEventPublisher;
import com.atlassian.lighthouse.notification.AuditNotificationService;
import com.atlassian.lighthouse.notification.NotificationService;
import com.atlassian.lighthouse.notification.mail.MailServiceInterface;
import com.atlassian.lighthouse.notification.template.MailTemplateFactory;
import com.atlassian.lighthouse.notification.template.MailTemplateRenderer;
import com.atlassian.lighthouse.notification.template.TemplateParametersService;
import com.atlassian.lighthouse.plugin.PluginInfo;
import com.atlassian.lighthouse.resource.EmailResourceProvider;
import com.atlassian.lighthouse.security.consumer.SecurityAuditConsumer;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.ThreatDetector;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.security.service.AuditEventHandlerService;
import com.atlassian.lighthouse.security.service.WebSudoEnforcerService;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.event.AnalyticsEventPublisher;
import com.atlassian.lighthouse.service.event.DailyAnalyticsEventPublisher;
import com.atlassian.lighthouse.service.event.EventToThreatsService;
import com.atlassian.lighthouse.service.feature.flagging.DefaultFeatureFlagService;
import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagService;
import com.atlassian.lighthouse.service.guard.GuardDetectService;
import com.atlassian.lighthouse.service.guard.GuardIntegrationMonitor;
import com.atlassian.lighthouse.service.guard.UnpushedGuardAlertsRetryService;
import com.atlassian.lighthouse.service.scheduler.DailyAnalyticsScheduleJobRunner;
import com.atlassian.lighthouse.service.scheduler.LighthouseScheduleLauncher;
import com.atlassian.lighthouse.service.scheduler.UnpushedGuardAlertsRetryJobRunner;
import com.atlassian.lighthouse.service.scheduler.UnpushedGuardAlertsRetryJobScheduler;
import com.atlassian.lighthouse.service.statistics.AlertStatisticsService;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.lighthouse.usage.service.CachingAuditUsageService;
import com.atlassian.lighthouse.usage.service.UserReferenceProvider;
import com.atlassian.lighthouse.usage.service.UserUsageStatisticsService;
import com.atlassian.lighthouse.usage.service.UserUsageStatisticsServiceImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceLocator;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CoreImportServiceConfig.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J \u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J(\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0001\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0017J\u0018\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J \u00100\u001a\u0002012\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0017J \u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0017J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0017J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J(\u0010B\u001a\u00020C2\u0006\u0010!\u001a\u00020\"2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010\t\u001a\u00020\nH\u0017J0\u0010H\u001a\u00020I2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010J\u001a\u00020G2\u0006\u0010B\u001a\u00020C2\u0006\u0010K\u001a\u00020LH\u0017J\u0010\u0010M\u001a\u00020N2\u0006\u00104\u001a\u000205H\u0017J\u0018\u0010O\u001a\u00020P2\u0006\u0010'\u001a\u00020(2\u0006\u0010Q\u001a\u00020RH\u0017J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0017J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0017J \u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\u0006\u0010D\u001a\u00020EH\u0017J(\u0010a\u001a\u00020L2\u0006\u0010b\u001a\u00020\\2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010\t\u001a\u00020\nH\u0017J(\u0010c\u001a\u00020`2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0017J0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020;2\u0006\u0010d\u001a\u00020e2\u0006\u0010W\u001a\u00020X2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0017J \u0010f\u001a\u00020\u001c2\u0006\u0010d\u001a\u00020e2\u0006\u0010g\u001a\u00020h2\u0006\u0010'\u001a\u00020(H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010i\u001a\u00020jH\u0017J(\u0010k\u001a\u00020l2\u0006\u00104\u001a\u0002052\u0006\u0010M\u001a\u00020N2\u0006\u0010'\u001a\u00020(2\u0006\u0010m\u001a\u00020nH\u0017J \u0010o\u001a\u00020p2\u0006\u0010M\u001a\u00020N2\u0006\u0010q\u001a\u00020r2\u0006\u0010O\u001a\u00020PH\u0017J(\u0010\u0019\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u0010s\u001a\u00020t2\u0006\u0010k\u001a\u00020l2\u0006\u0010@\u001a\u00020AH\u0017J\u0018\u0010'\u001a\u00020(2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020xH\u0017J\u0010\u0010i\u001a\u00020j2\u0006\u0010y\u001a\u00020zH\u0017J\u000e\u0010{\u001a\b\u0012\u0004\u0012\u00020-0,H\u0017J\u0010\u0010|\u001a\u00020}2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010~\u001a\u00020\u007fH\u0017J \u0010D\u001a\u00020E2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007fH\u0017J\u0012\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0006\u0010)\u001a\u00020*H\u0017JE\u0010m\u001a\u00020n2\u0006\u00104\u001a\u0002052\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0006\u0010'\u001a\u00020(2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010<\u001a\u00020=2\u0007\u0010\u0086\u0001\u001a\u00020A2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0017J\"\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0017J\u001e\u0010\u0089\u0001\u001a\u00030\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0017JL\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0006\u00106\u001a\u0002072\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0006\u0010<\u001a\u00020=2\b\u0010\u0095\u0001\u001a\u00030\u0088\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0017\u00a8\u0006\u009a\u0001"}, d2={"Lcom/atlassian/lighthouse/config/CoreBeanConfig;", "", "()V", "alertDao", "Lcom/atlassian/lighthouse/database/dao/AlertDao;", "activeObjects", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "alertEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/AlertEntityMapper;", "threatEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/ThreatEntityMapper;", "alertManager", "Lcom/atlassian/lighthouse/database/dao/AlertManager;", "threatEventDao", "Lcom/atlassian/lighthouse/database/dao/ThreatEventDao;", "analyticsEventPublisher", "Lcom/atlassian/lighthouse/service/event/AnalyticsEventPublisher;", "transactionHandler", "Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "notificationService", "Lcom/atlassian/lighthouse/notification/NotificationService;", "guardDetectService", "Lcom/atlassian/lighthouse/service/guard/GuardDetectService;", "guardIntegrationMonitor", "Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "alertStatisticsManager", "Lcom/atlassian/lighthouse/database/dao/AlertStatisticsManager;", "alertStatisticsService", "Lcom/atlassian/lighthouse/service/statistics/AlertStatisticsService;", "dailyAnalyticsEventPublisher", "Lcom/atlassian/lighthouse/service/event/DailyAnalyticsEventPublisher;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "auditEventHandlerService", "Lcom/atlassian/lighthouse/security/service/AuditEventHandlerService;", "threatDetectors", "", "Lcom/atlassian/lighthouse/security/detector/ThreatDetector;", "auditNotificationEventPublisher", "Lcom/atlassian/lighthouse/notification/AuditNotificationEventPublisher;", "auditNotificationService", "Lcom/atlassian/lighthouse/notification/AuditNotificationService;", "auditService", "Lcom/atlassian/audit/api/AuditService;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "cachingAuditUsageService", "Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService;", "auditSearchService", "Lcom/atlassian/audit/api/AuditSearchService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "dailyAnalyticsScheduleJobRunner", "Lcom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner;", "scheduleJobManager", "Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "dailyAnalyticsScheduleLauncher", "Lcom/atlassian/lighthouse/service/scheduler/LighthouseScheduleLauncher;", "scheduleService", "unpushedGuardAlertsRetryJobScheduler", "Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler;", "emailAlertTypeI18nMapper", "Lcom/atlassian/lighthouse/i18n/EmailAlertTypeI18nMapper;", "emailResourceProvider", "Lcom/atlassian/lighthouse/resource/EmailResourceProvider;", "webResourceUrlProvider", "Lcom/atlassian/webresource/api/WebResourceUrlProvider;", "eventToThreatsService", "Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "threatEventEntityFactory", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "featureFlagService", "Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;", "darkFeatureManager", "Lcom/atlassian/sal/api/features/DarkFeatureManager;", "guardAlertsRetryJobRunner", "Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "unpushedGuardAlertsRetryService", "Lcom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService;", "guardAlertsRetryJobScheduler", "unpushedGuardAlertsRetryJobRunner", "guardAlertsRetryService", "cloudRequestServiceLocator", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequestServiceLocator;", "guardPremiumService", "cloudObjectMapper", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudObjectMapper;", "propertyHelper", "Lcom/atlassian/lighthouse/config/system/PropertyHelper;", "mailTemplateFactory", "Lcom/atlassian/lighthouse/notification/template/MailTemplateFactory;", "templateParametersService", "Lcom/atlassian/lighthouse/notification/template/TemplateParametersService;", "mailTemplateRenderer", "Lcom/atlassian/lighthouse/notification/template/MailTemplateRenderer;", "soyTemplateRenderer", "Lcom/atlassian/soy/renderer/SoyTemplateRenderer;", "mailServiceInterface", "Lcom/atlassian/lighthouse/notification/mail/MailServiceInterface;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "systemPropertyProvider", "Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;", "refappThreatDetectors", "scheduleJobDao", "Lcom/atlassian/lighthouse/database/dao/ScheduleJobDao;", "scheduleJobEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/ScheduleJobEntityMapper;", "securityAuditConsumer", "Lcom/atlassian/audit/api/AuditConsumer;", "localeResolver", "Lcom/atlassian/sal/api/message/LocaleResolver;", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "userService", "userAlertStatusCountsManager", "Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager;", "userPermissionService", "Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "permissionEnforcer", "Lcom/atlassian/sal/api/permission/PermissionEnforcer;", "webSudoManager", "Lcom/atlassian/sal/api/websudo/WebSudoManager;", "userUsageStatisticsService", "Lcom/atlassian/lighthouse/usage/service/UserUsageStatisticsService;", "auditRetentionConfigService", "Lcom/atlassian/audit/api/AuditRetentionConfigService;", "threadLocalDelegateExecutorFactory", "Lcom/atlassian/sal/api/executor/ThreadLocalDelegateExecutorFactory;", "cachingUserAlertStatusCountsManager", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "userReferenceProvider", "Lcom/atlassian/lighthouse/usage/service/UserReferenceProvider;", "atlassian-lighthouse-core"})
public class CoreBeanConfig {
    @Bean
    @NotNull
    public AlertDeactivationService alertDeactivationService(@NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new AlertDeactivationService(lighthouseConfig);
    }

    @Bean
    @NotNull
    public AuditEventHandlerService auditEventHandlerService(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @Qualifier(value="threatDetectors") @NotNull List<? extends ThreatDetector> threatDetectors) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(threatDetectors, "threatDetectors");
        return new AuditEventHandlerService(alertDeactivationService, alertService, threatDetectors);
    }

    @Bean
    @NotNull
    public AlertEntityMapper alertEntityMapper(@NotNull ThreatEntityMapper threatEntityMapper) {
        Intrinsics.checkNotNullParameter(threatEntityMapper, "threatEntityMapper");
        return new AlertEntityMapper(threatEntityMapper);
    }

    @Bean
    @NotNull
    public AlertDao alertDao(@NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter(activeObjects, "activeObjects");
        return new AlertDao(activeObjects);
    }

    @Bean
    @NotNull
    public AnalyticsEventPublisher analyticsEventPublisher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        return new AnalyticsEventPublisher(eventPublisher, pluginInfo);
    }

    @Bean
    @NotNull
    public AlertManager alertManager(@NotNull AlertDao alertDao, @NotNull AlertEntityMapper alertEntityMapper, @NotNull ThreatEventDao threatEventDao, @NotNull AnalyticsEventPublisher analyticsEventPublisher, @Qualifier(value="transactionHandler") @NotNull TransactionHandler transactionHandler) {
        Intrinsics.checkNotNullParameter(alertDao, "alertDao");
        Intrinsics.checkNotNullParameter(alertEntityMapper, "alertEntityMapper");
        Intrinsics.checkNotNullParameter(threatEventDao, "threatEventDao");
        Intrinsics.checkNotNullParameter(analyticsEventPublisher, "analyticsEventPublisher");
        Intrinsics.checkNotNullParameter(transactionHandler, "transactionHandler");
        return new AlertManager(alertDao, alertEntityMapper, threatEventDao, CoreBeanConfig::alertManager$lambda$0, transactionHandler, CoreBeanConfig::alertManager$lambda$1, analyticsEventPublisher);
    }

    @Bean
    @NotNull
    public CachingUserAlertStatusCountsManager userAlertStatusCountsManager(@NotNull AlertManager alertManager, @NotNull CacheManager cacheManager, @NotNull TimeZoneManager timeZoneManager) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        return new CachingUserAlertStatusCountsManager(alertManager, cacheManager, timeZoneManager);
    }

    @Bean
    @NotNull
    public AlertService alertService(@NotNull AlertManager alertManager, @NotNull NotificationService notificationService, @NotNull GuardDetectService guardDetectService, @NotNull GuardIntegrationMonitor guardIntegrationMonitor) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter(notificationService, "notificationService");
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        return new AlertService(alertManager, notificationService, guardDetectService, guardIntegrationMonitor);
    }

    @Bean
    @NotNull
    public EmailAlertTypeI18nMapper emailAlertTypeI18nMapper(@NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        return new EmailAlertTypeI18nMapper(i18nResolver);
    }

    @Bean
    @NotNull
    public AuditNotificationService auditNotificationService(@NotNull AuditNotificationEventPublisher auditNotificationEventPublisher, @NotNull AuditService auditService, @NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(auditNotificationEventPublisher, "auditNotificationEventPublisher");
        Intrinsics.checkNotNullParameter(auditService, "auditService");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        return new AuditNotificationService(auditNotificationEventPublisher, auditService, i18nResolver);
    }

    @Bean
    @NotNull
    public ThreatEntityMapper threatEntityMapper() {
        return new ThreatEntityMapper();
    }

    @Bean
    @NotNull
    public CommonDetectionFunctions commonDetectionFunctions(@NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        return new CommonDetectionFunctions(securityUserService);
    }

    @Bean
    @NotNull
    public ThreatEventDao threatEventDao(@NotNull ActiveObjects activeObjects, @NotNull ThreatEntityMapper threatEntityMapper) {
        Intrinsics.checkNotNullParameter(activeObjects, "activeObjects");
        Intrinsics.checkNotNullParameter(threatEntityMapper, "threatEntityMapper");
        return new ThreatEventDao(activeObjects, threatEntityMapper);
    }

    @Bean
    @NotNull
    public PluginInfo pluginInfo(@NotNull PluginAccessor pluginAccessor, @NotNull ApplicationProperties applicationProperties) {
        Intrinsics.checkNotNullParameter(pluginAccessor, "pluginAccessor");
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        return new PluginInfo(pluginAccessor, applicationProperties);
    }

    @Bean(value={"lighthouse-security-consumer"})
    @NotNull
    public AuditConsumer securityAuditConsumer(@NotNull AuditEventHandlerService auditEventHandlerService) {
        Intrinsics.checkNotNullParameter(auditEventHandlerService, "auditEventHandlerService");
        return new SecurityAuditConsumer(auditEventHandlerService);
    }

    @Bean(value={"threatDetectors"})
    @Conditional(value={RefappOnly.class})
    @NotNull
    public List<ThreatDetector> refappThreatDetectors() {
        return CollectionsKt.emptyList();
    }

    @Bean(value={"notificationService"})
    @NotNull
    public NotificationService notificationService(@NotNull AuditNotificationService auditNotificationService, @NotNull MailServiceInterface mailServiceInterface, @NotNull MailTemplateFactory mailTemplateFactory, @NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(auditNotificationService, "auditNotificationService");
        Intrinsics.checkNotNullParameter(mailServiceInterface, "mailServiceInterface");
        Intrinsics.checkNotNullParameter(mailTemplateFactory, "mailTemplateFactory");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        return new NotificationService(auditNotificationService, mailServiceInterface, mailTemplateFactory, securityUserService);
    }

    @Bean
    @NotNull
    public MailTemplateFactory mailTemplateFactory(@NotNull I18nResolver i18nResolver, @NotNull EmailAlertTypeI18nMapper emailAlertTypeI18nMapper, @NotNull PluginInfo pluginInfo, @NotNull TemplateParametersService templateParametersService) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(emailAlertTypeI18nMapper, "emailAlertTypeI18nMapper");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(templateParametersService, "templateParametersService");
        return new MailTemplateFactory(emailAlertTypeI18nMapper, i18nResolver, pluginInfo, templateParametersService);
    }

    @Bean
    @NotNull
    public TemplateParametersService templateParametersService(@NotNull I18nResolver i18nResolver, @NotNull LocaleResolver localeResolver, @NotNull PluginInfo pluginInfo, @NotNull UserDetailsFinder userDetailsFinder, @NotNull TimeZoneManager timeZoneManager, @NotNull SecurityUserService userService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(localeResolver, "localeResolver");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(userDetailsFinder, "userDetailsFinder");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        Intrinsics.checkNotNullParameter(userService, "userService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new TemplateParametersService(i18nResolver, localeResolver, pluginInfo.getProductId(), lighthouseConfig.getSecurityGroupName(), userService, timeZoneManager, userDetailsFinder);
    }

    @Bean
    @NotNull
    public MailTemplateRenderer mailTemplateRenderer(@NotNull EmailAlertTypeI18nMapper emailAlertTypeI18nMapper, @NotNull SoyTemplateRenderer soyTemplateRenderer, @NotNull EmailResourceProvider emailResourceProvider) {
        Intrinsics.checkNotNullParameter(emailAlertTypeI18nMapper, "emailAlertTypeI18nMapper");
        Intrinsics.checkNotNullParameter(soyTemplateRenderer, "soyTemplateRenderer");
        Intrinsics.checkNotNullParameter(emailResourceProvider, "emailResourceProvider");
        return new MailTemplateRenderer(emailAlertTypeI18nMapper, soyTemplateRenderer, emailResourceProvider);
    }

    @Bean
    @NotNull
    public AlertStatisticsManager alertStatisticsManager(@NotNull AlertDao alertDao, @NotNull TransactionHandler transactionHandler) {
        Intrinsics.checkNotNullParameter(alertDao, "alertDao");
        Intrinsics.checkNotNullParameter(transactionHandler, "transactionHandler");
        return new AlertStatisticsManager(alertDao, transactionHandler);
    }

    @Bean
    @NotNull
    public AlertStatisticsService alertStatisticsService(@NotNull AlertStatisticsManager alertStatisticsManager, @NotNull DailyAnalyticsEventPublisher dailyAnalyticsEventPublisher, @NotNull GuardIntegrationMonitor guardIntegrationMonitor) {
        Intrinsics.checkNotNullParameter(alertStatisticsManager, "alertStatisticsManager");
        Intrinsics.checkNotNullParameter(dailyAnalyticsEventPublisher, "dailyAnalyticsEventPublisher");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        return new AlertStatisticsService(alertStatisticsManager, dailyAnalyticsEventPublisher, guardIntegrationMonitor);
    }

    @Bean
    @NotNull
    public AuditNotificationEventPublisher auditNotificationEventPublisher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        return new AuditNotificationEventPublisher(eventPublisher, pluginInfo);
    }

    @Bean
    @NotNull
    public DailyAnalyticsEventPublisher dailyAnalyticsEventPublisher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        return new DailyAnalyticsEventPublisher(eventPublisher, pluginInfo);
    }

    @Bean
    @NotNull
    public DailyAnalyticsScheduleJobRunner dailyAnalyticsScheduleJobRunner(@NotNull AlertStatisticsService alertStatisticsService, @NotNull ScheduleJobManager scheduleJobManager, @NotNull SchedulerService schedulerService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(alertStatisticsService, "alertStatisticsService");
        Intrinsics.checkNotNullParameter(scheduleJobManager, "scheduleJobManager");
        Intrinsics.checkNotNullParameter(schedulerService, "schedulerService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new DailyAnalyticsScheduleJobRunner(alertStatisticsService, scheduleJobManager, schedulerService, lighthouseConfig);
    }

    @Bean
    @NotNull
    public LighthouseScheduleLauncher dailyAnalyticsScheduleLauncher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo, @NotNull SchedulerService scheduleService, @NotNull DailyAnalyticsScheduleJobRunner dailyAnalyticsScheduleJobRunner, @NotNull UnpushedGuardAlertsRetryJobScheduler unpushedGuardAlertsRetryJobScheduler) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(scheduleService, "scheduleService");
        Intrinsics.checkNotNullParameter(dailyAnalyticsScheduleJobRunner, "dailyAnalyticsScheduleJobRunner");
        Intrinsics.checkNotNullParameter(unpushedGuardAlertsRetryJobScheduler, "unpushedGuardAlertsRetryJobScheduler");
        return new LighthouseScheduleLauncher(eventPublisher, pluginInfo, scheduleService, dailyAnalyticsScheduleJobRunner, unpushedGuardAlertsRetryJobScheduler);
    }

    @Bean
    @NotNull
    public ScheduleJobDao scheduleJobDao(@NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter(activeObjects, "activeObjects");
        return new ScheduleJobDao(activeObjects);
    }

    @Bean
    @NotNull
    public ScheduleJobEntityMapper scheduleJobEntityMapper() {
        return new ScheduleJobEntityMapper();
    }

    @Bean
    @NotNull
    public ScheduleJobManager scheduleJobManager(@NotNull ActiveObjects activeObjects, @NotNull ScheduleJobDao scheduleJobDao, @NotNull ScheduleJobEntityMapper scheduleJobEntityMapper) {
        Intrinsics.checkNotNullParameter(activeObjects, "activeObjects");
        Intrinsics.checkNotNullParameter(scheduleJobDao, "scheduleJobDao");
        Intrinsics.checkNotNullParameter(scheduleJobEntityMapper, "scheduleJobEntityMapper");
        return new ScheduleJobManager(activeObjects, scheduleJobDao, scheduleJobEntityMapper);
    }

    @Bean
    @NotNull
    public CachingAuditUsageService cachingAuditUsageService(@NotNull AuditSearchService auditSearchService, @NotNull CacheManager cacheManager, @NotNull TimeZoneManager timeZoneManager) {
        Intrinsics.checkNotNullParameter(auditSearchService, "auditSearchService");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        return new CachingAuditUsageService(auditSearchService, cacheManager, timeZoneManager, null, 8, null);
    }

    @Bean
    @NotNull
    public UserUsageStatisticsService userUsageStatisticsService(@NotNull AuditRetentionConfigService auditRetentionConfigService, @NotNull CachingAuditUsageService cachingAuditUsageService, @NotNull ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, @NotNull TimeZoneManager timeZoneManager, @NotNull CachingUserAlertStatusCountsManager cachingUserAlertStatusCountsManager, @NotNull UserManager userManager, @NotNull UserReferenceProvider userReferenceProvider) {
        Intrinsics.checkNotNullParameter(auditRetentionConfigService, "auditRetentionConfigService");
        Intrinsics.checkNotNullParameter(cachingAuditUsageService, "cachingAuditUsageService");
        Intrinsics.checkNotNullParameter(threadLocalDelegateExecutorFactory, "threadLocalDelegateExecutorFactory");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        Intrinsics.checkNotNullParameter(cachingUserAlertStatusCountsManager, "cachingUserAlertStatusCountsManager");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(userReferenceProvider, "userReferenceProvider");
        Supplier<Instant> supplier = CoreBeanConfig::userUsageStatisticsService$lambda$2;
        return new UserUsageStatisticsServiceImpl(auditRetentionConfigService, cachingAuditUsageService, threadLocalDelegateExecutorFactory, supplier, timeZoneManager, cachingUserAlertStatusCountsManager, userManager, userReferenceProvider);
    }

    @Bean
    @NotNull
    public EmailResourceProvider emailResourceProvider(@NotNull PluginInfo pluginInfo, @NotNull WebResourceUrlProvider webResourceUrlProvider) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(webResourceUrlProvider, "webResourceUrlProvider");
        return new EmailResourceProvider(pluginInfo, webResourceUrlProvider);
    }

    @Bean
    @NotNull
    public EventToThreatsService eventToThreatsService(@NotNull ThreatEventEntityFactory threatEventEntityFactory) {
        Intrinsics.checkNotNullParameter(threatEventEntityFactory, "threatEventEntityFactory");
        return new EventToThreatsService(threatEventEntityFactory);
    }

    @Bean
    @NotNull
    public PropertyHelper propertyHelper(@NotNull SystemPropertyProvider systemPropertyProvider) {
        Intrinsics.checkNotNullParameter(systemPropertyProvider, "systemPropertyProvider");
        return new PropertyHelper(systemPropertyProvider);
    }

    @Bean
    @NotNull
    public LighthouseConfig lighthouseConfig(@NotNull PropertyHelper propertyHelper) {
        Intrinsics.checkNotNullParameter(propertyHelper, "propertyHelper");
        return new LighthouseConfig(propertyHelper);
    }

    @Bean
    @NotNull
    public FeatureFlagService featureFlagService(@NotNull DarkFeatureManager darkFeatureManager) {
        Intrinsics.checkNotNullParameter(darkFeatureManager, "darkFeatureManager");
        return new DefaultFeatureFlagService(darkFeatureManager);
    }

    @Bean
    @NotNull
    public WebSudoEnforcerService userPermissionService(@NotNull PermissionEnforcer permissionEnforcer, @NotNull WebSudoManager webSudoManager) {
        Intrinsics.checkNotNullParameter(permissionEnforcer, "permissionEnforcer");
        Intrinsics.checkNotNullParameter(webSudoManager, "webSudoManager");
        return new WebSudoEnforcerService(permissionEnforcer, webSudoManager);
    }

    @Bean
    @NotNull
    public GuardDetectService guardPremiumService(@NotNull CloudRequestServiceLocator cloudRequestServiceLocator, @NotNull CloudObjectMapper cloudObjectMapper, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(cloudRequestServiceLocator, "cloudRequestServiceLocator");
        Intrinsics.checkNotNullParameter(cloudObjectMapper, "cloudObjectMapper");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        return new GuardDetectService(cloudRequestServiceLocator, cloudObjectMapper, pluginInfo);
    }

    @Bean
    @NotNull
    public UnpushedGuardAlertsRetryService guardAlertsRetryService(@NotNull AlertManager alertManager, @NotNull GuardDetectService guardDetectService, @NotNull GuardIntegrationMonitor guardIntegrationMonitor, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new UnpushedGuardAlertsRetryService(alertManager, guardDetectService, guardIntegrationMonitor, lighthouseConfig);
    }

    @Bean
    @NotNull
    public UnpushedGuardAlertsRetryJobScheduler guardAlertsRetryJobScheduler(@NotNull UnpushedGuardAlertsRetryJobRunner unpushedGuardAlertsRetryJobRunner, @NotNull ScheduleJobManager scheduleJobManager, @NotNull SchedulerService schedulerService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(unpushedGuardAlertsRetryJobRunner, "unpushedGuardAlertsRetryJobRunner");
        Intrinsics.checkNotNullParameter(scheduleJobManager, "scheduleJobManager");
        Intrinsics.checkNotNullParameter(schedulerService, "schedulerService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new UnpushedGuardAlertsRetryJobScheduler(unpushedGuardAlertsRetryJobRunner, scheduleJobManager, schedulerService, lighthouseConfig);
    }

    @Bean
    @NotNull
    public UnpushedGuardAlertsRetryJobRunner guardAlertsRetryJobRunner(@NotNull ClusterLockService clusterLockService, @NotNull UnpushedGuardAlertsRetryService unpushedGuardAlertsRetryService, @NotNull ScheduleJobManager scheduleJobManager) {
        Intrinsics.checkNotNullParameter(clusterLockService, "clusterLockService");
        Intrinsics.checkNotNullParameter(unpushedGuardAlertsRetryService, "unpushedGuardAlertsRetryService");
        Intrinsics.checkNotNullParameter(scheduleJobManager, "scheduleJobManager");
        return new UnpushedGuardAlertsRetryJobRunner(clusterLockService, unpushedGuardAlertsRetryService, scheduleJobManager);
    }

    @Bean
    @NotNull
    public GuardIntegrationMonitor guardIntegrationMonitor(@NotNull CacheManager cacheManager, @NotNull CloudRequestServiceLocator cloudRequestServiceLocator, @NotNull FeatureFlagService featureFlagService, @NotNull GuardDetectService guardDetectService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(cloudRequestServiceLocator, "cloudRequestServiceLocator");
        Intrinsics.checkNotNullParameter(featureFlagService, "featureFlagService");
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new GuardIntegrationMonitor(cloudRequestServiceLocator, featureFlagService, guardDetectService, lighthouseConfig);
    }

    private static final Long alertManager$lambda$0() {
        return Instant.now().toEpochMilli();
    }

    private static final String alertManager$lambda$1() {
        return UUID.randomUUID().toString();
    }

    private static final Instant userUsageStatisticsService$lambda$2() {
        return Instant.now();
    }
}

