/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config.system;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.lighthouse.config.system.SystemPropertyProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/lighthouse/config/system/BitbucketSystemPropertyProvider;", "Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;", "applicationPropertiesService", "Lcom/atlassian/bitbucket/server/ApplicationPropertiesService;", "(Lcom/atlassian/bitbucket/server/ApplicationPropertiesService;)V", "getSystemProperty", "", "kotlin.jvm.PlatformType", "propertyName", "getSystemPropertyOrDefault", "defaultValue", "atlassian-lighthouse-core"})
public final class BitbucketSystemPropertyProvider
implements SystemPropertyProvider {
    @NotNull
    private final ApplicationPropertiesService applicationPropertiesService;

    public BitbucketSystemPropertyProvider(@NotNull ApplicationPropertiesService applicationPropertiesService) {
        Intrinsics.checkNotNullParameter(applicationPropertiesService, "applicationPropertiesService");
        this.applicationPropertiesService = applicationPropertiesService;
    }

    @Override
    public String getSystemProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        return this.applicationPropertiesService.getPluginProperty(propertyName);
    }

    @Override
    @NotNull
    public String getSystemPropertyOrDefault(@NotNull String propertyName, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        String string = this.getSystemProperty(propertyName);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }
}

