/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config.system;

import com.atlassian.lighthouse.config.system.SystemPropertyProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/atlassian/lighthouse/config/system/DefaultSystemPropertyProvider;", "Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;", "()V", "getSystemProperty", "", "propertyName", "getSystemPropertyOrDefault", "defaultValue", "atlassian-lighthouse-core"})
public final class DefaultSystemPropertyProvider
implements SystemPropertyProvider {
    @Override
    @Nullable
    public String getSystemProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        return System.getProperty(propertyName);
    }

    @Override
    @NotNull
    public String getSystemPropertyOrDefault(@NotNull String propertyName, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        String string = System.getProperty(propertyName, defaultValue);
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }
}

