/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config.system;

import com.atlassian.lighthouse.config.system.SystemPropertyProvider;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ+\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/lighthouse/config/system/PropertyHelper;", "", "systemPropertyProvider", "Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;", "(Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;)V", "getSystemPropertyOrDefault", "", "propertyName", "", "defaultValue", "", "logIfDefault", "", "T", "value", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nPropertyHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyHelper.kt\ncom/atlassian/lighthouse/config/system/PropertyHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,48:1\n1#2:49\n11#3:50\n10#3,3:51\n*S KotlinDebug\n*F\n+ 1 PropertyHelper.kt\ncom/atlassian/lighthouse/config/system/PropertyHelper\n*L\n45#1:50\n45#1:51,3\n*E\n"})
public final class PropertyHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SystemPropertyProvider systemPropertyProvider;
    @NotNull
    private static final Logger logger;

    public PropertyHelper(@NotNull SystemPropertyProvider systemPropertyProvider) {
        Intrinsics.checkNotNullParameter(systemPropertyProvider, "systemPropertyProvider");
        this.systemPropertyProvider = systemPropertyProvider;
    }

    @NotNull
    public final String getSystemPropertyOrDefault(@NotNull String propertyName, @NotNull String defaultValue) {
        String string;
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        String it = string = this.systemPropertyProvider.getSystemPropertyOrDefault(propertyName, defaultValue);
        boolean bl = false;
        this.logIfDefault(it, propertyName, defaultValue);
        return string;
    }

    public final boolean getSystemPropertyOrDefault(@NotNull String propertyName, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Object object = this.systemPropertyProvider.getSystemProperty(propertyName);
        boolean it = bl = object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : defaultValue;
        boolean bl2 = false;
        this.logIfDefault(it, propertyName, defaultValue);
        return bl;
    }

    public final long getSystemPropertyOrDefault(@NotNull String propertyName, long defaultValue) {
        long l;
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Object object = this.systemPropertyProvider.getSystemProperty(propertyName);
        long it = l = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : defaultValue;
        boolean bl = false;
        this.logIfDefault(it, propertyName, defaultValue);
        return l;
    }

    private final <T> void logIfDefault(T value, String propertyName, T defaultValue) {
        if (Intrinsics.areEqual(value, defaultValue)) {
            logger.debug("[Atlassian Lighthouse] Failed to get system property {}, using default value instead: {}.", (Object)propertyName, defaultValue);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        PropertyHelper.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/config/system/PropertyHelper$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

