/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.lighthouse.database.dao.AlertDao;
import com.atlassian.lighthouse.database.dao.AlertsPage;
import com.atlassian.lighthouse.database.dao.ThreatEventDao;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.GuardPushStatus;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.database.entities.ao.AoAlert;
import com.atlassian.lighthouse.database.entities.ao.AoAlertThreatEvent;
import com.atlassian.lighthouse.database.mapper.AlertEntityMapper;
import com.atlassian.lighthouse.database.query.AlertsQuery;
import com.atlassian.lighthouse.database.query.PageRequest;
import com.atlassian.lighthouse.database.transactions.TransactionHandler;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.EmailStatus;
import com.atlassian.lighthouse.service.event.AnalyticsEventPublisher;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 U2\u00020\u0001:\u0001UBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0018\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u001a\u0010\u001a\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ,\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001cJ\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J2\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\n082\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u0015H\u0002J\u0010\u0010A\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u0015H\u0002J\u0016\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020DJ6\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001c2\u0018\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u001c08H\u0002J\u001a\u0010J\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u001a\u0010K\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\"\u0010L\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0\u001c\u0012\u0004\u0012\u00020N0M2\u0006\u00100\u001a\u000201H\u0002J(\u0010O\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u001c082\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001cH\u0002J\u0016\u0010P\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\n2\u0006\u0010Q\u001a\u00020%J\u001a\u0010R\u001a\u00020\u00162\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020D08J\u0010\u0010T\u001a\u00020\u00162\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/atlassian/lighthouse/database/dao/AlertManager;", "", "alertDao", "Lcom/atlassian/lighthouse/database/dao/AlertDao;", "alertEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/AlertEntityMapper;", "threatEventDao", "Lcom/atlassian/lighthouse/database/dao/ThreatEventDao;", "timestampSupplier", "Ljava/util/function/Supplier;", "", "transactionHandler", "Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;", "uuidSupplier", "", "analyticsPublisher", "Lcom/atlassian/lighthouse/service/event/AnalyticsEventPublisher;", "(Lcom/atlassian/lighthouse/database/dao/AlertDao;Lcom/atlassian/lighthouse/database/mapper/AlertEntityMapper;Lcom/atlassian/lighthouse/database/dao/ThreatEventDao;Ljava/util/function/Supplier;Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;Ljava/util/function/Supplier;Lcom/atlassian/lighthouse/service/event/AnalyticsEventPublisher;)V", "alertStatusChangeListeners", "", "Lkotlin/Function1;", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "", "createAlertChangeListeners", "addAlertCreateListener", "listener", "addStatusChangeListener", "bulkUpdateAlertStatusByUuid", "", "alertUuids", "status", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "createAlert", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "alertStatus", "emailStatus", "Lcom/atlassian/lighthouse/security/detector/EmailStatus;", "threatEventEntityList", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "generateStatusCountsMap", "", "aoQuery", "Lnet/java/ao/Query;", "getAlertByUuid", "alertUuid", "getAlerts", "Lcom/atlassian/lighthouse/database/dao/AlertsPage;", "query", "Lcom/atlassian/lighthouse/database/query/AlertsQuery;", "getUnpushedAlerts", "limit", "", "fromDate", "Ljava/time/Instant;", "getUserAlertStatusCountsForMonth", "", "userKey", "month", "Ljava/time/Month;", "year", "timezone", "Ljava/time/ZoneId;", "handleAlertCreation", "alertEntity", "handleAlertStatusChange", "logPushAttempt", "alertId", "Lcom/atlassian/lighthouse/database/entities/GuardPushStatus;", "mapToEntitiesOrThrow", "alerts", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlert;", "threatEventsByAlertId", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlertThreatEvent;", "removeAlertCreateListener", "removeStatusChangeListener", "retrieveAlerts", "Lkotlin/Pair;", "", "retrieveThreatEventsGroupedByAlertId", "updateEmailStatus", "newStatus", "updateGuardPushStatuses", "alertIdToStatusMap", "validatePageSize", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertManager.kt\ncom/atlassian/lighthouse/database/dao/AlertManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,364:1\n1#2:365\n1#2:369\n1855#3,2:366\n2634#3:368\n1855#3,2:370\n1549#3:372\n1620#3,3:373\n1549#3:376\n1620#3,3:377\n1477#3:380\n1502#3,3:381\n1505#3,3:391\n1549#3:394\n1620#3,3:395\n1855#3,2:398\n1855#3,2:400\n372#4,7:384\n215#5,2:402\n11#6:404\n10#6,3:405\n*S KotlinDebug\n*F\n+ 1 AlertManager.kt\ncom/atlassian/lighthouse/database/dao/AlertManager\n*L\n120#1:369\n83#1:366,2\n120#1:368\n127#1:370,2\n325#1:372\n325#1:373,3\n334#1:376\n334#1:377,3\n340#1:380\n340#1:381,3\n340#1:391,3\n67#1:394\n67#1:395,3\n69#1:398,2\n111#1:400,2\n340#1:384,7\n180#1:402,2\n43#1:404\n43#1:405,3\n*E\n"})
public final class AlertManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertDao alertDao;
    @NotNull
    private final AlertEntityMapper alertEntityMapper;
    @NotNull
    private final ThreatEventDao threatEventDao;
    @NotNull
    private final Supplier<Long> timestampSupplier;
    @NotNull
    private final TransactionHandler transactionHandler;
    @NotNull
    private final Supplier<String> uuidSupplier;
    @NotNull
    private final AnalyticsEventPublisher analyticsPublisher;
    @NotNull
    private final List<Function1<AlertEntity, Unit>> alertStatusChangeListeners;
    @NotNull
    private final List<Function1<AlertEntity, Unit>> createAlertChangeListeners;
    public static final int MAX_PAGE_SIZE = 1000;
    public static final int MAX_ALERT_UPDATES_PER_TRANSACTION = 1000;
    @NotNull
    private static final Logger logger;

    public AlertManager(@NotNull AlertDao alertDao, @NotNull AlertEntityMapper alertEntityMapper, @NotNull ThreatEventDao threatEventDao, @NotNull Supplier<Long> timestampSupplier, @NotNull TransactionHandler transactionHandler, @NotNull Supplier<String> uuidSupplier, @NotNull AnalyticsEventPublisher analyticsPublisher) {
        Intrinsics.checkNotNullParameter(alertDao, "alertDao");
        Intrinsics.checkNotNullParameter(alertEntityMapper, "alertEntityMapper");
        Intrinsics.checkNotNullParameter(threatEventDao, "threatEventDao");
        Intrinsics.checkNotNullParameter(timestampSupplier, "timestampSupplier");
        Intrinsics.checkNotNullParameter(transactionHandler, "transactionHandler");
        Intrinsics.checkNotNullParameter(uuidSupplier, "uuidSupplier");
        Intrinsics.checkNotNullParameter(analyticsPublisher, "analyticsPublisher");
        this.alertDao = alertDao;
        this.alertEntityMapper = alertEntityMapper;
        this.threatEventDao = threatEventDao;
        this.timestampSupplier = timestampSupplier;
        this.transactionHandler = transactionHandler;
        this.uuidSupplier = uuidSupplier;
        this.analyticsPublisher = analyticsPublisher;
        this.alertStatusChangeListeners = new ArrayList();
        this.createAlertChangeListeners = new ArrayList();
    }

    @NotNull
    public final AlertEntity createAlert(@NotNull AlertType alertType, @NotNull AlertStatus alertStatus, @NotNull EmailStatus emailStatus, @NotNull List<ThreatEventEntity> threatEventEntityList) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter((Object)alertStatus, "alertStatus");
        Intrinsics.checkNotNullParameter((Object)emailStatus, "emailStatus");
        Intrinsics.checkNotNullParameter(threatEventEntityList, "threatEventEntityList");
        Object t = this.transactionHandler.executeInTransaction(() -> AlertManager.createAlert$lambda$3(threatEventEntityList, this, alertType, alertStatus, emailStatus));
        AlertEntity it = (AlertEntity)t;
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        this.handleAlertCreation(it);
        Object t2 = t;
        Intrinsics.checkNotNullExpressionValue(t2, "also(...)");
        return (AlertEntity)t2;
    }

    private final void handleAlertCreation(AlertEntity alertEntity) {
        Iterable $this$forEach$iv = this.createAlertChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 listener = (Function1)element$iv;
            boolean bl = false;
            try {
                listener.invoke(alertEntity);
            }
            catch (Exception e) {
                logger.error("Error while handling alert creation", (Throwable)e);
            }
        }
    }

    @NotNull
    public final List<AlertEntity> bulkUpdateAlertStatusByUuid(@NotNull List<String> alertUuids, @NotNull AlertStatus status) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(alertUuids, "alertUuids");
        Intrinsics.checkNotNullParameter((Object)status, "status");
        if (!(alertUuids.size() <= 1000)) {
            boolean $i$a$-require-AlertManager$bulkUpdateAlertStatusByUuid$22 = false;
            String $i$a$-require-AlertManager$bulkUpdateAlertStatusByUuid$22 = "Exceeded maximum number of alerts that can be updated in a single transaction: 1000";
            throw new IllegalArgumentException($i$a$-require-AlertManager$bulkUpdateAlertStatusByUuid$22.toString());
        }
        Iterable $this$onEach$iv = (Iterable)this.transactionHandler.executeInTransaction(() -> AlertManager.bulkUpdateAlertStatusByUuid$lambda$8(this, alertUuids, status));
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            AlertEntity it = (AlertEntity)element$iv;
            boolean bl2 = false;
            this.handleAlertStatusChange(it);
        }
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullExpressionValue(iterable2, "onEach(...)");
        return (List)iterable2;
    }

    private final void handleAlertStatusChange(AlertEntity alertEntity) {
        Iterable $this$forEach$iv = this.alertStatusChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 listener = (Function1)element$iv;
            boolean bl = false;
            try {
                listener.invoke(alertEntity);
            }
            catch (Exception e) {
                logger.error("Error while handling alert status change", (Throwable)e);
            }
        }
    }

    @NotNull
    public final List<AlertEntity> getUnpushedAlerts(int limit, @NotNull Instant fromDate) {
        Intrinsics.checkNotNullParameter(fromDate, "fromDate");
        Object t = this.transactionHandler.executeInTransaction(() -> AlertManager.getUnpushedAlerts$lambda$11(this, fromDate, limit));
        Intrinsics.checkNotNullExpressionValue(t, "executeInTransaction(...)");
        return (List)t;
    }

    public final void logPushAttempt(long alertId, @NotNull GuardPushStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, "status");
        this.transactionHandler.executeInTransaction(() -> AlertManager.logPushAttempt$lambda$12(this, alertId, status));
    }

    public final void updateGuardPushStatuses(@NotNull Map<Long, ? extends GuardPushStatus> alertIdToStatusMap) {
        Intrinsics.checkNotNullParameter(alertIdToStatusMap, "alertIdToStatusMap");
        this.transactionHandler.executeInTransaction(() -> AlertManager.updateGuardPushStatuses$lambda$14(alertIdToStatusMap, this));
    }

    public final void updateEmailStatus(long alertId, @NotNull EmailStatus newStatus) {
        Intrinsics.checkNotNullParameter((Object)newStatus, "newStatus");
        this.transactionHandler.executeInTransaction(() -> AlertManager.updateEmailStatus$lambda$15(this, alertId, newStatus));
    }

    @Nullable
    public final AlertEntity getAlertByUuid(@NotNull String alertUuid) {
        Intrinsics.checkNotNullParameter(alertUuid, "alertUuid");
        return (AlertEntity)this.transactionHandler.executeInTransaction(() -> AlertManager.getAlertByUuid$lambda$16(this, alertUuid));
    }

    @NotNull
    public final AlertsPage getAlerts(@NotNull AlertsQuery query) {
        Intrinsics.checkNotNullParameter(query, "query");
        this.validatePageSize(query);
        Object t = this.transactionHandler.executeInTransaction(() -> AlertManager.getAlerts$lambda$17(this, query));
        Intrinsics.checkNotNullExpressionValue(t, "executeInTransaction(...)");
        return (AlertsPage)t;
    }

    @NotNull
    public final Map<AlertStatus, Long> getUserAlertStatusCountsForMonth(@NotNull String userKey, @NotNull Month month, int year, @NotNull ZoneId timezone) {
        Intrinsics.checkNotNullParameter(userKey, "userKey");
        Intrinsics.checkNotNullParameter(month, "month");
        Intrinsics.checkNotNullParameter(timezone, "timezone");
        ZonedDateTime startOfMonth = ZonedDateTime.of(year, month.getValue(), 1, 0, 0, 0, 0, timezone);
        ZonedDateTime endOfMonth = startOfMonth.plusMonths(1L);
        Set<String> set = SetsKt.setOf(userKey);
        Instant instant = startOfMonth.toInstant();
        Instant instant2 = endOfMonth.toInstant();
        Query query = new AlertsQuery(null, instant, instant2, null, set, null, null, null, 169, null).activeObjectsQuery(CollectionsKt.listOf("ALERT_STATUS"));
        if (query == null) {
            return MapsKt.emptyMap();
        }
        Query aoQuery = query;
        Object t = this.transactionHandler.executeInTransaction(() -> AlertManager.getUserAlertStatusCountsForMonth$lambda$18(this, aoQuery));
        Intrinsics.checkNotNullExpressionValue(t, "executeInTransaction(...)");
        return (Map)t;
    }

    private final Map<AlertStatus, Long> generateStatusCountsMap(Query aoQuery) {
        Map statusCounts = new LinkedHashMap();
        Ref.IntRef invalidAlerts = new Ref.IntRef();
        this.alertDao.streamAlerts(aoQuery, (Function1<? super AoAlert, Unit>)new Function1<AoAlert, Unit>((Map<AlertStatus, Long>)statusCounts, invalidAlerts){
            final /* synthetic */ Map<AlertStatus, Long> $statusCounts;
            final /* synthetic */ Ref.IntRef $invalidAlerts;
            {
                this.$statusCounts = $statusCounts;
                this.$invalidAlerts = $invalidAlerts;
                super(1);
            }

            public final void invoke(@NotNull AoAlert alert) {
                Intrinsics.checkNotNullParameter(alert, "alert");
                AlertStatus maybeStatus = AlertStatus.Companion.fromValue(alert.getAlertStatus());
                if (maybeStatus != null) {
                    this.$statusCounts.put(maybeStatus, ((Number)this.$statusCounts.getOrDefault((Object)((Object)maybeStatus), 0L)).longValue() + 1L);
                } else {
                    int n = this.$invalidAlerts.element;
                    this.$invalidAlerts.element = n + 1;
                }
            }
        });
        if (invalidAlerts.element > 0) {
            logger.warn("Found " + invalidAlerts.element + " alerts with invalid statuses while processing user alert status counts.");
        }
        return statusCounts;
    }

    public final void addStatusChangeListener(@NotNull Function1<? super AlertEntity, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.alertStatusChangeListeners.add(listener);
    }

    public final void removeStatusChangeListener(@NotNull Function1<? super AlertEntity, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.alertStatusChangeListeners.remove(listener);
    }

    public final void addAlertCreateListener(@NotNull Function1<? super AlertEntity, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.createAlertChangeListeners.add(listener);
    }

    public final void removeAlertCreateListener(@NotNull Function1<? super AlertEntity, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.createAlertChangeListeners.remove(listener);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AlertEntity> mapToEntitiesOrThrow(List<? extends AoAlert> alerts, Map<Long, ? extends List<? extends AoAlertThreatEvent>> threatEventsByAlertId) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = alerts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void alert;
            AoAlert aoAlert = (AoAlert)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<AoAlertThreatEvent> list = threatEventsByAlertId.get(alert.getId());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            collection.add(this.alertEntityMapper.mapAoAlertToAlertEntityOrThrow((AoAlert)alert, list));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, List<AoAlertThreatEvent>> retrieveThreatEventsGroupedByAlertId(List<? extends AoAlert> alerts) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = alerts;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AoAlert aoAlert = (AoAlert)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List alertIds = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.threatEventDao.getThreatEventsByAlertIds(alertIds);
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            AoAlertThreatEvent it = (AoAlertThreatEvent)element$iv$iv;
            boolean bl = false;
            AoAlert aoAlert = it.getAlert();
            Intrinsics.checkNotNull(aoAlert);
            Long key$iv$iv = aoAlert.getId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map threatEventsByAlertId = destination$iv$iv2;
        return threatEventsByAlertId;
    }

    private final Pair<List<AoAlert>, Boolean> retrieveAlerts(AlertsQuery query) {
        if (query.getPageRequest() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        AlertsQuery queryWithExtraResult = AlertsQuery.copy$default(query, null, null, null, null, null, null, PageRequest.copy$default(query.getPageRequest(), query.getPageRequest().getSize() + 1, null, null, 6, null), null, 191, null);
        Query query2 = AlertsQuery.activeObjectsQuery$default(queryWithExtraResult, null, 1, null);
        if (query2 == null) {
            return new Pair<List<AoAlert>, Boolean>(CollectionsKt.emptyList(), false);
        }
        Query activeObjectQuery = query2;
        List<AoAlert> alertsWithExtraResult = this.alertDao.getAlerts(activeObjectQuery);
        boolean nextPageExists = alertsWithExtraResult.size() > query.getPageRequest().getSize();
        List alerts = CollectionsKt.take((Iterable)alertsWithExtraResult, query.getPageRequest().getSize());
        return new Pair<List<AoAlert>, Boolean>(alerts, nextPageExists);
    }

    private final void validatePageSize(AlertsQuery query) {
        if (query.getPageRequest() == null) {
            boolean $i$a$-requireNotNull-AlertManager$validatePageSize$22 = false;
            String $i$a$-requireNotNull-AlertManager$validatePageSize$22 = "Can only fetch paged results";
            throw new IllegalArgumentException($i$a$-requireNotNull-AlertManager$validatePageSize$22.toString());
        }
        int n = query.getPageRequest().getSize();
        if (!(0 <= n ? n < 1001 : false)) {
            boolean bl = false;
            String string = "Page size must be less than or equal to 1000 and must not be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final AlertEntity createAlert$lambda$3(List $threatEventEntityList, AlertManager this$0, AlertType $alertType, AlertStatus $alertStatus, EmailStatus $emailStatus) {
        void $this$mapTo$iv$iv;
        long l;
        Object object;
        Intrinsics.checkNotNullParameter($threatEventEntityList, "$threatEventEntityList");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter((Object)$alertType, "$alertType");
        Intrinsics.checkNotNullParameter((Object)$alertStatus, "$alertStatus");
        Intrinsics.checkNotNullParameter((Object)$emailStatus, "$emailStatus");
        Iterator iterator2 = ((Iterable)$threatEventEntityList).iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = (ThreatEventEntity)iterator2.next();
            boolean bl = false;
            it = ((ThreatEventEntity)it).getCreatedTime();
            while (iterator2.hasNext()) {
                Object it2 = (ThreatEventEntity)iterator2.next();
                $i$a$-maxOfOrNull-AlertManager$createAlert$1$timestamp$1 = false;
                if (it.compareTo(it2 = (Comparable)((ThreatEventEntity)it2).getCreatedTime()) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Instant instant = (Instant)object;
        if (instant != null) {
            l = instant.toEpochMilli();
        } else {
            Long l2 = this$0.timestampSupplier.get();
            Intrinsics.checkNotNullExpressionValue(l2, "get(...)");
            l = ((Number)l2).longValue();
        }
        long timestamp = l;
        AlertDao alertDao = this$0.alertDao;
        String string = this$0.uuidSupplier.get();
        Intrinsics.checkNotNullExpressionValue(string, "get(...)");
        AoAlert aoAlert = alertDao.createAlert($alertType, $alertStatus, $emailStatus, null, string, timestamp);
        Iterable $this$map$iv = $threatEventEntityList;
        boolean $i$f$map = false;
        Iterable it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreatEventEntity threatEventEntity = (ThreatEventEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.threatEventDao.createThreatEventWithAlertId((ThreatEventEntity)it, aoAlert.getId()));
        }
        List aoThreatEventList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = aoThreatEventList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AoAlertThreatEvent it = (AoAlertThreatEvent)element$iv;
            boolean bl = false;
            logger.debug("[Atlassian Lighthouse] Persisted threat event. Time: " + it.getCreatedTime() + " Action: " + it.getActionI18nKey());
        }
        return this$0.alertEntityMapper.mapAoAlertToAlertEntity(aoAlert, $alertType, $alertStatus, $emailStatus, aoThreatEventList);
    }

    private static final List bulkUpdateAlertStatusByUuid$lambda$8(AlertManager this$0, List $alertUuids, AlertStatus $status) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($alertUuids, "$alertUuids");
        Intrinsics.checkNotNullParameter((Object)$status, "$status");
        List<AoAlert> aoAlerts = this$0.alertDao.getAlertsByUuid($alertUuids);
        Iterable $this$forEach$iv = aoAlerts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AoAlert it = (AoAlert)element$iv;
            boolean bl = false;
            this$0.analyticsPublisher.publishAlertStatusChangedAnalyticEvent(it.getAlertStatus(), $status.getValue(), it.getUuid());
            it.setAlertStatus($status.getValue());
            it.save();
        }
        Map<Long, List<AoAlertThreatEvent>> threatEventsByAlertId = this$0.retrieveThreatEventsGroupedByAlertId(aoAlerts);
        return this$0.mapToEntitiesOrThrow(aoAlerts, threatEventsByAlertId);
    }

    private static final List getUnpushedAlerts$lambda$11(AlertManager this$0, Instant $fromDate, int $limit) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($fromDate, "$fromDate");
        AlertDao alertDao = this$0.alertDao;
        Object[] objectArray = new Object[]{GuardPushStatus.CREATED_BEFORE_INTEGRATION, GuardPushStatus.FAILED, $fromDate.toEpochMilli()};
        Query query = Query.select().where("(GUARD_PUSH_STATUS IS NULL OR GUARD_PUSH_STATUS IN (?, ?)) AND ALERT_TIMESTAMP > ?", objectArray).order("ALERT_TIMESTAMP ASC").limit($limit);
        Intrinsics.checkNotNullExpressionValue(query, "limit(...)");
        List<AoAlert> aoAlerts = alertDao.getAlerts(query);
        Map<Long, List<AoAlertThreatEvent>> threatEventsByAlertId = this$0.retrieveThreatEventsGroupedByAlertId(aoAlerts);
        return this$0.mapToEntitiesOrThrow(aoAlerts, threatEventsByAlertId);
    }

    private static final Unit logPushAttempt$lambda$12(AlertManager this$0, long $alertId, GuardPushStatus $status) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter((Object)$status, "$status");
        AoAlert aoAlert = this$0.alertDao.getById($alertId);
        if (aoAlert == null) {
            throw new IllegalArgumentException("Alert not found for ID = " + $alertId);
        }
        AoAlert alert = aoAlert;
        alert.setGuardPushStatus($status);
        alert.save();
        return Unit.INSTANCE;
    }

    private static final Unit updateGuardPushStatuses$lambda$14(Map $alertIdToStatusMap, AlertManager this$0) {
        Intrinsics.checkNotNullParameter($alertIdToStatusMap, "$alertIdToStatusMap");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Map $this$forEach$iv = $alertIdToStatusMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            AoAlert alert;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            long alertId = ((Number)entry.getKey()).longValue();
            GuardPushStatus newStatus = (GuardPushStatus)((Object)entry.getValue());
            if (this$0.alertDao.getById(alertId) == null) {
                throw new IllegalArgumentException("Alert not found for ID = " + alertId);
            }
            alert.setGuardPushStatus(newStatus);
            if (newStatus == GuardPushStatus.FAILED || newStatus == GuardPushStatus.FAILED_MAX_RETRIES) {
                int n = alert.getGuardRetryCount();
                alert.setGuardRetryCount(n + 1);
            }
            alert.save();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateEmailStatus$lambda$15(AlertManager this$0, long $alertId, EmailStatus $newStatus) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter((Object)$newStatus, "$newStatus");
        AoAlert aoAlert = this$0.alertDao.getById($alertId);
        if (aoAlert == null) {
            throw new IllegalArgumentException("Alert not found for ID = " + $alertId);
        }
        AoAlert alert = aoAlert;
        alert.setEmailStatus($newStatus.value());
        alert.setQueuedTimestamp(this$0.timestampSupplier.get());
        alert.save();
        return Unit.INSTANCE;
    }

    private static final AlertEntity getAlertByUuid$lambda$16(AlertManager this$0, String $alertUuid) {
        AlertEntity alertEntity;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($alertUuid, "$alertUuid");
        AoAlert aoAlert = this$0.alertDao.getByUuid($alertUuid);
        if (aoAlert == null) {
            logger.debug("[Atlassian Lighthouse] Alert not found for UUID = " + $alertUuid);
            alertEntity = null;
        } else {
            alertEntity = this$0.alertEntityMapper.mapAoAlertToAlertEntityOrThrow(aoAlert, this$0.threatEventDao.getThreatEventsByAlertId(aoAlert.getId()));
        }
        return alertEntity;
    }

    private static final AlertsPage getAlerts$lambda$17(AlertManager this$0, AlertsQuery $query) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($query, "$query");
        Pair<List<AoAlert>, Boolean> pair = this$0.retrieveAlerts($query);
        List<AoAlert> alerts = pair.component1();
        boolean nextPageExists = pair.component2();
        Map<Long, List<AoAlertThreatEvent>> threatEventsByAlertId = this$0.retrieveThreatEventsGroupedByAlertId(alerts);
        List<AlertEntity> alertEntities = this$0.mapToEntitiesOrThrow(alerts, threatEventsByAlertId);
        return AlertsPage.Companion.of($query, alertEntities, nextPageExists);
    }

    private static final Map getUserAlertStatusCountsForMonth$lambda$18(AlertManager this$0, Query $aoQuery) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($aoQuery, "$aoQuery");
        return this$0.generateStatusCountsMap($aoQuery);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AlertManager.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/lighthouse/database/dao/AlertManager$Companion;", "", "()V", "MAX_ALERT_UPDATES_PER_TRANSACTION", "", "MAX_PAGE_SIZE", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

