/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.lighthouse.database.dao.AlertDao;
import com.atlassian.lighthouse.database.dao.AlertStatisticsManager;
import com.atlassian.lighthouse.database.entities.GuardPushStatus;
import com.atlassian.lighthouse.database.entities.ao.AoAlert;
import com.atlassian.lighthouse.database.query.AlertsQuery;
import com.atlassian.lighthouse.database.transactions.TransactionHandler;
import com.atlassian.lighthouse.dto.AlertStatusStatistics;
import com.atlassian.lighthouse.dto.AlertTypeStatistics;
import com.atlassian.lighthouse.dto.GuardDetectAlertStatistics;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\n0\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001H\t0\u0010H\u0002JF\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\n0\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001H\t0\u0010H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/lighthouse/database/dao/AlertStatisticsManager;", "", "alertDao", "Lcom/atlassian/lighthouse/database/dao/AlertDao;", "transactionHandler", "Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;", "(Lcom/atlassian/lighthouse/database/dao/AlertDao;Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;)V", "collateAlertsByColumn", "", "T", "", "query", "Lcom/atlassian/lighthouse/database/query/AlertsQuery;", "column", "", "mapper", "Lkotlin/Function1;", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlert;", "columns", "", "getAlertStatusStatistics", "Lcom/atlassian/lighthouse/dto/AlertStatusStatistics;", "getAlertTypeStatistics", "Lcom/atlassian/lighthouse/dto/AlertTypeStatistics;", "getGuardDetectAlertStatistics", "Lcom/atlassian/lighthouse/dto/GuardDetectAlertStatistics;", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertStatisticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertStatisticsManager.kt\ncom/atlassian/lighthouse/database/dao/AlertStatisticsManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n453#2:95\n403#2:96\n1238#3,4:97\n*S KotlinDebug\n*F\n+ 1 AlertStatisticsManager.kt\ncom/atlassian/lighthouse/database/dao/AlertStatisticsManager\n*L\n27#1:95\n27#1:96\n27#1:97,4\n*E\n"})
public final class AlertStatisticsManager {
    @NotNull
    private final AlertDao alertDao;
    @NotNull
    private final TransactionHandler transactionHandler;

    public AlertStatisticsManager(@NotNull AlertDao alertDao, @NotNull TransactionHandler transactionHandler) {
        Intrinsics.checkNotNullParameter(alertDao, "alertDao");
        Intrinsics.checkNotNullParameter(transactionHandler, "transactionHandler");
        this.alertDao = alertDao;
        this.transactionHandler = transactionHandler;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AlertTypeStatistics getAlertTypeStatistics(@NotNull AlertsQuery query) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(query, "query");
        Ref.LongRef total = new Ref.LongRef();
        Map alertCounts = this.collateAlertsByColumn(query, "ALERT_TYPE", (Function1)new Function1<AoAlert, String>(total){
            final /* synthetic */ Ref.LongRef $total;
            {
                this.$total = $total;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull AoAlert alert) {
                Intrinsics.checkNotNullParameter(alert, "alert");
                ++this.$total.element;
                return alert.getAlertTypeId();
            }
        });
        boolean bl = false;
        Map $this$mapValues$iv = alertCounts;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Long l = ((Number)it.getValue()).longValue();
            map3.put(k, l);
        }
        long l = total.element;
        Map map4 = destination$iv$iv;
        return new AlertTypeStatistics(map4, l);
    }

    @NotNull
    public final AlertStatusStatistics getAlertStatusStatistics(@NotNull AlertsQuery query) {
        Intrinsics.checkNotNullParameter(query, "query");
        Ref.LongRef total = new Ref.LongRef();
        Map<AlertStatus, Long> alertCounts = this.collateAlertsByColumn(query, "ALERT_STATUS", (Function1)new Function1<AoAlert, AlertStatus>(total){
            final /* synthetic */ Ref.LongRef $total;
            {
                this.$total = $total;
                super(1);
            }

            @Nullable
            public final AlertStatus invoke(@NotNull AoAlert alert) {
                Intrinsics.checkNotNullParameter(alert, "alert");
                ++this.$total.element;
                return AlertStatus.Companion.fromValue(alert.getAlertStatus());
            }
        });
        boolean bl = false;
        return new AlertStatusStatistics(alertCounts, total.element);
    }

    @NotNull
    public final GuardDetectAlertStatistics getGuardDetectAlertStatistics(@NotNull AlertsQuery query) {
        Intrinsics.checkNotNullParameter(query, "query");
        Ref.IntRef totalSuccessfulAlerts = new Ref.IntRef();
        Ref.IntRef totalFailedAlerts = new Ref.IntRef();
        Ref.IntRef totalFailedMaxRetryAlerts = new Ref.IntRef();
        Ref.IntRef maximumRetryCount = new Ref.IntRef();
        String[] stringArray = new String[]{"GUARD_PUSH_STATUS", "GUARD_RETRY_COUNT"};
        this.collateAlertsByColumn(query, CollectionsKt.listOf(stringArray), (Function1)new Function1<AoAlert, Unit>(totalSuccessfulAlerts, totalFailedAlerts, totalFailedMaxRetryAlerts, maximumRetryCount){
            final /* synthetic */ Ref.IntRef $totalSuccessfulAlerts;
            final /* synthetic */ Ref.IntRef $totalFailedAlerts;
            final /* synthetic */ Ref.IntRef $totalFailedMaxRetryAlerts;
            final /* synthetic */ Ref.IntRef $maximumRetryCount;
            {
                this.$totalSuccessfulAlerts = $totalSuccessfulAlerts;
                this.$totalFailedAlerts = $totalFailedAlerts;
                this.$totalFailedMaxRetryAlerts = $totalFailedMaxRetryAlerts;
                this.$maximumRetryCount = $maximumRetryCount;
                super(1);
            }

            public final void invoke(@NotNull AoAlert alert) {
                Intrinsics.checkNotNullParameter(alert, "alert");
                GuardPushStatus guardPushStatus = alert.getGuardPushStatus();
                switch (guardPushStatus == null ? -1 : getGuardDetectAlertStatistics.WhenMappings.$EnumSwitchMapping$0[guardPushStatus.ordinal()]) {
                    case 1: {
                        ++this.$totalSuccessfulAlerts.element;
                        break;
                    }
                    case 2: {
                        ++this.$totalFailedAlerts.element;
                        break;
                    }
                    case 3: {
                        ++this.$totalFailedMaxRetryAlerts.element;
                    }
                }
                if (alert.getGuardRetryCount() > this.$maximumRetryCount.element) {
                    this.$maximumRetryCount.element = alert.getGuardRetryCount();
                }
            }
        });
        return new GuardDetectAlertStatistics(totalSuccessfulAlerts.element, totalFailedAlerts.element, totalFailedMaxRetryAlerts.element, maximumRetryCount.element);
    }

    private final <T> Map<T, Long> collateAlertsByColumn(AlertsQuery query, String column, Function1<? super AoAlert, ? extends T> mapper) {
        return this.collateAlertsByColumn(query, CollectionsKt.listOf(column), mapper);
    }

    private final <T> Map<T, Long> collateAlertsByColumn(AlertsQuery query, List<String> columns, Function1<? super AoAlert, ? extends T> mapper) {
        Query query2 = AlertsQuery.copy$default(query, null, null, null, null, null, null, null, null, 191, null).activeObjectsQuery(columns);
        if (query2 == null) {
            return MapsKt.emptyMap();
        }
        Query activeObjectQuery = query2;
        Map alertCounts = new LinkedHashMap();
        this.transactionHandler.executeInTransaction(() -> AlertStatisticsManager.collateAlertsByColumn$lambda$3(this, activeObjectQuery, mapper, alertCounts));
        return alertCounts;
    }

    private static final Unit collateAlertsByColumn$lambda$3(AlertStatisticsManager this$0, Query $activeObjectQuery, Function1 $mapper, Map $alertCounts) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($activeObjectQuery, "$activeObjectQuery");
        Intrinsics.checkNotNullParameter($mapper, "$mapper");
        Intrinsics.checkNotNullParameter($alertCounts, "$alertCounts");
        this$0.alertDao.streamAlerts($activeObjectQuery, (Function1<? super AoAlert, Unit>)new Function1<AoAlert, Unit>($mapper, $alertCounts){
            final /* synthetic */ Function1<AoAlert, T> $mapper;
            final /* synthetic */ Map<T, Long> $alertCounts;
            {
                this.$mapper = $mapper;
                this.$alertCounts = $alertCounts;
                super(1);
            }

            public final void invoke(@NotNull AoAlert alert) {
                Intrinsics.checkNotNullParameter(alert, "alert");
                T columnValue = this.$mapper.invoke(alert);
                if (columnValue != null) {
                    this.$alertCounts.put(columnValue, ((Number)this.$alertCounts.getOrDefault(columnValue, 0L)).longValue() + 1L);
                }
            }
        });
        return Unit.INSTANCE;
    }
}

