/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.lighthouse.database.entities.ao.AoAlertScheduledJob;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/database/dao/ScheduleJobDao;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "createScheduleJob", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlertScheduledJob;", "jobKey", "", "lastSuccessfulRun", "", "(Ljava/lang/String;Ljava/lang/Long;)Lcom/atlassian/lighthouse/database/entities/ao/AoAlertScheduledJob;", "getById", "id", "getByJobKey", "updateScheduleJob", "atlassian-lighthouse-core"})
public final class ScheduleJobDao {
    @NotNull
    private final ActiveObjects ao;

    public ScheduleJobDao(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter(ao, "ao");
        this.ao = ao;
    }

    @Nullable
    public final AoAlertScheduledJob getById(long id) {
        Object[] objectArray = new Object[]{id};
        RawEntity[] rawEntityArray = this.ao.find(AoAlertScheduledJob.class, "ID = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return (AoAlertScheduledJob)ArraysKt.getOrNull((Object[])rawEntityArray, 0);
    }

    @Nullable
    public final AoAlertScheduledJob getByJobKey(@NotNull String jobKey) {
        Intrinsics.checkNotNullParameter(jobKey, "jobKey");
        Object[] objectArray = new Object[]{jobKey};
        RawEntity[] rawEntityArray = this.ao.find(AoAlertScheduledJob.class, "JOB_KEY = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return (AoAlertScheduledJob)ArraysKt.getOrNull((Object[])rawEntityArray, 0);
    }

    @NotNull
    public final AoAlertScheduledJob createScheduleJob(@NotNull String jobKey, @Nullable Long lastSuccessfulRun) {
        Intrinsics.checkNotNullParameter(jobKey, "jobKey");
        DBParam[] dBParamArray = new DBParam[]{new DBParam("JOB_KEY", (Object)jobKey), new DBParam("LAST_SUCCESSFUL_RUN", (Object)lastSuccessfulRun)};
        RawEntity rawEntity = this.ao.create(AoAlertScheduledJob.class, dBParamArray);
        Intrinsics.checkNotNullExpressionValue(rawEntity, "create(...)");
        return (AoAlertScheduledJob)rawEntity;
    }

    @NotNull
    public final AoAlertScheduledJob updateScheduleJob(@NotNull String jobKey, @Nullable Long lastSuccessfulRun) {
        Intrinsics.checkNotNullParameter(jobKey, "jobKey");
        AoAlertScheduledJob aoAlertScheduledJob = this.getByJobKey(jobKey);
        if (aoAlertScheduledJob == null) {
            return this.createScheduleJob(jobKey, lastSuccessfulRun);
        }
        AoAlertScheduledJob scheduleJob = aoAlertScheduledJob;
        scheduleJob.setJobKey(jobKey);
        scheduleJob.setLastSuccessfulRun(lastSuccessfulRun);
        scheduleJob.save();
        return scheduleJob;
    }
}

