/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.mapper;

import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.database.entities.ao.AoAlertThreatEvent;
import java.time.Instant;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/database/mapper/ThreatEntityMapper;", "", "()V", "createExtraAttributeMap", "", "", "aoAlertThreatEvent", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlertThreatEvent;", "mapAoThreatEventToThreatEventEntity", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "mapThreatEntityToAoDbParams", "", "threatEvent", "alertId", "", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nThreatEntityMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreatEntityMapper.kt\ncom/atlassian/lighthouse/database/mapper/ThreatEntityMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1045#2:77\n1864#2,3:78\n1#3:81\n*S KotlinDebug\n*F\n+ 1 ThreatEntityMapper.kt\ncom/atlassian/lighthouse/database/mapper/ThreatEntityMapper\n*L\n35#1:77\n35#1:78,3\n*E\n"})
public final class ThreatEntityMapper {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> mapThreatEntityToAoDbParams(@NotNull ThreatEventEntity threatEvent, long alertId) {
        void $this$forEachIndexed$iv;
        Map map;
        Intrinsics.checkNotNullParameter(threatEvent, "threatEvent");
        Map $this$mapThreatEntityToAoDbParams_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("ACTION_T_KEY", threatEvent.getActionI18nKey());
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("CREATED_TIME", threatEvent.getCreatedTime().toEpochMilli());
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EVENT_SOURCE", threatEvent.getEventSource());
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("NODE", threatEvent.getNodeId());
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("SOURCE_IP", threatEvent.getSourceIp());
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("INSTANCE_BASE_URL", threatEvent.getInstanceBaseUrl());
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("ALERT_ID", alertId);
        $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("TRIGGERING_USER_KEY", threatEvent.getTriggeringUserKey());
        Iterable $this$sortedBy$iv = threatEvent.getExtraAttributes().entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getKey())));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv;
            int index = n;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            switch (index) {
                case 0: {
                    $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EXTRA_ATTRIBUTE_T_KEY_1", key);
                    $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EXTRA_ATTRIBUTE_VALUE_COLUMN_1", value);
                    break;
                }
                case 1: {
                    $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EXTRA_ATTRIBUTE_T_KEY_2", key);
                    $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EXTRA_ATTRIBUTE_VALUE_COLUMN_2", value);
                    break;
                }
                case 2: {
                    $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EXTRA_ATTRIBUTE_T_KEY_3", key);
                    $this$mapThreatEntityToAoDbParams_u24lambda_u242.put("EXTRA_ATTRIBUTE_VALUE_COLUMN_3", value);
                    break;
                }
                case 3: {
                    throw new IllegalArgumentException("Cannot have more than 3 extra attributes");
                }
            }
        }
        return map;
    }

    @NotNull
    public final ThreatEventEntity mapAoThreatEventToThreatEventEntity(@NotNull AoAlertThreatEvent aoAlertThreatEvent) {
        Intrinsics.checkNotNullParameter(aoAlertThreatEvent, "aoAlertThreatEvent");
        String string = aoAlertThreatEvent.getActionI18nKey();
        String string2 = aoAlertThreatEvent.getEventSource();
        Map<String, String> map = this.createExtraAttributeMap(aoAlertThreatEvent);
        String string3 = aoAlertThreatEvent.getTriggeringUserKey();
        Long l = aoAlertThreatEvent.getId();
        String string4 = aoAlertThreatEvent.getNodeId();
        String string5 = aoAlertThreatEvent.getSourceIp();
        String string6 = aoAlertThreatEvent.getInstanceBaseUrl();
        Instant instant = Instant.ofEpochMilli(aoAlertThreatEvent.getCreatedTime());
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(...)");
        return new ThreatEventEntity(string, string2, map, string3, l, string4, string5, string6, instant);
    }

    private final Map<String, String> createExtraAttributeMap(AoAlertThreatEvent aoAlertThreatEvent) {
        Map map;
        block2: {
            String it;
            Map $this$createExtraAttributeMap_u24lambda_u246 = map = (Map)new LinkedHashMap();
            boolean bl = false;
            String string = aoAlertThreatEvent.getExtraAttributeKeyOne();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$createExtraAttributeMap_u24lambda_u246.put(it, aoAlertThreatEvent.getExtraAttributeValueOne());
            }
            String string2 = aoAlertThreatEvent.getExtraAttributeKeyTwo();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$createExtraAttributeMap_u24lambda_u246.put(it, aoAlertThreatEvent.getExtraAttributeValueTwo());
            }
            String string3 = aoAlertThreatEvent.getExtraAttributeKeyThree();
            if (string3 == null) break block2;
            it = string3;
            boolean bl4 = false;
            $this$createExtraAttributeMap_u24lambda_u246.put(it, aoAlertThreatEvent.getExtraAttributeValueThree());
        }
        return map;
    }
}

