/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.query;

import com.atlassian.lighthouse.database.query.Cursor;
import com.atlassian.lighthouse.database.query.Order;
import com.atlassian.lighthouse.database.query.WhereClause;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/lighthouse/database/query/PageRequest;", "", "size", "", "order", "Lcom/atlassian/lighthouse/database/query/Order;", "cursor", "Lcom/atlassian/lighthouse/database/query/Cursor;", "(ILcom/atlassian/lighthouse/database/query/Order;Lcom/atlassian/lighthouse/database/query/Cursor;)V", "getCursor", "()Lcom/atlassian/lighthouse/database/query/Cursor;", "getOrder", "()Lcom/atlassian/lighthouse/database/query/Order;", "getSize", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "whereClause", "Lcom/atlassian/lighthouse/database/query/WhereClause;", "idColumnName", "Companion", "atlassian-lighthouse-core"})
public final class PageRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final Order order;
    @Nullable
    private final Cursor cursor;
    public static final int DEFAULT_PAGE_SIZE = 10;

    public PageRequest(int size, @NotNull Order order, @Nullable Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)order, "order");
        this.size = size;
        this.order = order;
        this.cursor = cursor;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Order getOrder() {
        return this.order;
    }

    @Nullable
    public final Cursor getCursor() {
        return this.cursor;
    }

    @Nullable
    public final WhereClause whereClause(@NotNull String idColumnName) {
        WhereClause whereClause;
        Intrinsics.checkNotNullParameter(idColumnName, "idColumnName");
        Cursor cursor = this.cursor;
        if (cursor != null) {
            Cursor it = cursor;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.order.ordinal()]) {
                case 1: {
                    whereClause = WhereClause.Companion.lessThan(idColumnName, it.getId());
                    break;
                }
                case 2: {
                    whereClause = WhereClause.Companion.greaterThan(idColumnName, it.getId());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            whereClause = null;
        }
        return whereClause;
    }

    public final int component1() {
        return this.size;
    }

    @NotNull
    public final Order component2() {
        return this.order;
    }

    @Nullable
    public final Cursor component3() {
        return this.cursor;
    }

    @NotNull
    public final PageRequest copy(int size, @NotNull Order order, @Nullable Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)order, "order");
        return new PageRequest(size, order, cursor);
    }

    public static /* synthetic */ PageRequest copy$default(PageRequest pageRequest, int n, Order order, Cursor cursor, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = pageRequest.size;
        }
        if ((n2 & 2) != 0) {
            order = pageRequest.order;
        }
        if ((n2 & 4) != 0) {
            cursor = pageRequest.cursor;
        }
        return pageRequest.copy(n, order, cursor);
    }

    @NotNull
    public String toString() {
        return "PageRequest(size=" + this.size + ", order=" + this.order + ", cursor=" + this.cursor + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.size);
        result = result * 31 + this.order.hashCode();
        result = result * 31 + (this.cursor == null ? 0 : this.cursor.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PageRequest)) {
            return false;
        }
        PageRequest pageRequest = (PageRequest)other;
        if (this.size != pageRequest.size) {
            return false;
        }
        if (this.order != pageRequest.order) {
            return false;
        }
        return Intrinsics.areEqual(this.cursor, pageRequest.cursor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/lighthouse/database/query/PageRequest$Companion;", "", "()V", "DEFAULT_PAGE_SIZE", "", "first", "Lcom/atlassian/lighthouse/database/query/PageRequest;", "size", "last", "next", "following", "Lcom/atlassian/lighthouse/database/query/Cursor;", "previous", "preceding", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PageRequest first(int size) {
            return new PageRequest(size, Order.NATURAL, null);
        }

        public static /* synthetic */ PageRequest first$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 10;
            }
            return companion.first(n);
        }

        @NotNull
        public final PageRequest last(int size) {
            return new PageRequest(size, Order.REVERSE, null);
        }

        public static /* synthetic */ PageRequest last$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 10;
            }
            return companion.last(n);
        }

        @NotNull
        public final PageRequest next(@NotNull Cursor following, int size) {
            Intrinsics.checkNotNullParameter(following, "following");
            return new PageRequest(size, Order.NATURAL, following);
        }

        public static /* synthetic */ PageRequest next$default(Companion companion, Cursor cursor, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 10;
            }
            return companion.next(cursor, n);
        }

        @NotNull
        public final PageRequest previous(@NotNull Cursor preceding, int size) {
            Intrinsics.checkNotNullParameter(preceding, "preceding");
            return new PageRequest(size, Order.REVERSE, preceding);
        }

        public static /* synthetic */ PageRequest previous$default(Companion companion, Cursor cursor, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 10;
            }
            return companion.previous(cursor, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Order.values().length];
            try {
                nArray[Order.NATURAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Order.REVERSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

