/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.query;

import com.atlassian.lighthouse.database.query.WhereClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/database/query/WhereClause;", "", "clause", "", "parameters", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "getClause", "()Ljava/lang/String;", "getParameters", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "Companion", "atlassian-lighthouse-core"})
public final class WhereClause {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clause;
    @NotNull
    private final Object[] parameters;

    public WhereClause(@NotNull String clause, Object ... parameters) {
        Intrinsics.checkNotNullParameter(clause, "clause");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        this.clause = clause;
        this.parameters = parameters;
    }

    @NotNull
    public final String getClause() {
        return this.clause;
    }

    @NotNull
    public final Object[] getParameters() {
        return this.parameters;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0006\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J/\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0006\"\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J%\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0006\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/lighthouse/database/query/WhereClause$Companion;", "", "()V", "and", "Lcom/atlassian/lighthouse/database/query/WhereClause;", "conditions", "", "([Lcom/atlassian/lighthouse/database/query/WhereClause;)Lcom/atlassian/lighthouse/database/query/WhereClause;", "combineWhereClauses", "separator", "", "(Ljava/lang/String;[Lcom/atlassian/lighthouse/database/query/WhereClause;)Lcom/atlassian/lighthouse/database/query/WhereClause;", "equals", "column", "value", "greaterThan", "greaterThanOrEqual", "isIn", "values", "", "lessThan", "lessThanOrEqual", "or", "atlassian-lighthouse-core"})
    @SourceDebugExtension(value={"SMAP\nWhereClause.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhereClause.kt\ncom/atlassian/lighthouse/database/query/WhereClause$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,93:1\n1#2:94\n1855#3,2:95\n37#4,2:97\n37#4,2:99\n*S KotlinDebug\n*F\n+ 1 WhereClause.kt\ncom/atlassian/lighthouse/database/query/WhereClause$Companion\n*L\n31#1:95,2\n34#1:97,2\n48#1:99,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final WhereClause and(WhereClause ... conditions) {
            Intrinsics.checkNotNullParameter(conditions, "conditions");
            return this.combineWhereClauses("AND", Arrays.copyOf(conditions, conditions.length));
        }

        @Nullable
        public final WhereClause or(WhereClause ... conditions) {
            Intrinsics.checkNotNullParameter(conditions, "conditions");
            return this.combineWhereClauses("OR", Arrays.copyOf(conditions, conditions.length));
        }

        /*
         * WARNING - void declaration
         */
        private final WhereClause combineWhereClauses(String separator, WhereClause ... conditions) {
            List<WhereClause> filteredConditions = ArraysKt.filterNotNull(conditions);
            if (filteredConditions.isEmpty()) {
                return null;
            }
            Iterable iterable = filteredConditions;
            int n = 0;
            for (Object object : iterable) {
                void it;
                WhereClause whereClause = (WhereClause)object;
                int n2 = n;
                boolean bl = false;
                int n3 = it.getParameters().length;
                n = n2 + n3;
            }
            int parametersSize = n;
            ArrayList parameters = new ArrayList(parametersSize);
            Iterable $this$forEach$iv = filteredConditions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WhereClause it = (WhereClause)element$iv;
                boolean bl = false;
                CollectionsKt.addAll((Collection)parameters, it.getParameters());
            }
            Collection $this$toTypedArray$iv = parameters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            return new WhereClause(CollectionsKt.joinToString$default(filteredConditions, " " + separator + " ", "(", ")", 0, null, combineWhereClauses.2.INSTANCE, 24, null), Arrays.copyOf(objectArray, objectArray.length));
        }

        @NotNull
        public final WhereClause isIn(@NotNull String column, @NotNull List<? extends Object> values2) {
            Intrinsics.checkNotNullParameter(column, "column");
            Intrinsics.checkNotNullParameter(values2, "values");
            if (!(!((Collection)values2).isEmpty())) {
                boolean $i$a$-require-WhereClause$Companion$isIn$22 = false;
                String $i$a$-require-WhereClause$Companion$isIn$22 = "isIn where clause must provide at least one potential option";
                throw new IllegalArgumentException($i$a$-require-WhereClause$Companion$isIn$22.toString());
            }
            Collection $this$toTypedArray$iv = values2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            return new WhereClause(column + " IN " + CollectionsKt.joinToString$default(values2, ",", "(", ")", 0, null, isIn.2.INSTANCE, 24, null), Arrays.copyOf(objectArray, objectArray.length));
        }

        @NotNull
        public final WhereClause lessThan(@NotNull String column, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(column, "column");
            Intrinsics.checkNotNullParameter(value, "value");
            Object[] objectArray = new Object[]{value};
            return new WhereClause(column + " < ?", objectArray);
        }

        @NotNull
        public final WhereClause greaterThan(@NotNull String column, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(column, "column");
            Intrinsics.checkNotNullParameter(value, "value");
            Object[] objectArray = new Object[]{value};
            return new WhereClause(column + " > ?", objectArray);
        }

        @NotNull
        public final WhereClause lessThanOrEqual(@NotNull String column, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(column, "column");
            Intrinsics.checkNotNullParameter(value, "value");
            Object[] objectArray = new Object[]{value};
            return new WhereClause(column + " <= ?", objectArray);
        }

        @NotNull
        public final WhereClause greaterThanOrEqual(@NotNull String column, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(column, "column");
            Intrinsics.checkNotNullParameter(value, "value");
            Object[] objectArray = new Object[]{value};
            return new WhereClause(column + " >= ?", objectArray);
        }

        @NotNull
        public final WhereClause equals(@NotNull String column, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(column, "column");
            Intrinsics.checkNotNullParameter(value, "value");
            Object[] objectArray = new Object[]{value};
            return new WhereClause(column + " = ?", objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

