/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.frontend;

import com.atlassian.lighthouse.frontend.data.LighthouseAdminDataProvider;
import com.atlassian.lighthouse.frontend.security.UserAuthorizationService;
import com.atlassian.lighthouse.frontend.services.ProductInfoService;
import com.atlassian.lighthouse.security.service.WebSudoEnforcerService;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="lighthouse-admin")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/lighthouse/frontend/LighthouseAdminServlet;", "Ljakarta/servlet/http/HttpServlet;", "pageBuilderService", "Lcom/atlassian/webresource/api/assembler/PageBuilderService;", "soyTemplateRenderer", "Lcom/atlassian/soy/renderer/SoyTemplateRenderer;", "permissionEnforcer", "Lcom/atlassian/sal/api/permission/PermissionEnforcer;", "loginUriProvider", "Lcom/atlassian/sal/api/auth/LoginUriProvider;", "lighthouseAdminDataProvider", "Lcom/atlassian/lighthouse/frontend/data/LighthouseAdminDataProvider;", "userAuthorizationService", "Lcom/atlassian/lighthouse/frontend/security/UserAuthorizationService;", "webSudoEnforcerService", "Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "productInfoService", "Lcom/atlassian/lighthouse/frontend/services/ProductInfoService;", "webSudoManager", "Lcom/atlassian/sal/api/websudo/WebSudoManager;", "(Lcom/atlassian/webresource/api/assembler/PageBuilderService;Lcom/atlassian/soy/renderer/SoyTemplateRenderer;Lcom/atlassian/sal/api/permission/PermissionEnforcer;Lcom/atlassian/sal/api/auth/LoginUriProvider;Lcom/atlassian/lighthouse/frontend/data/LighthouseAdminDataProvider;Lcom/atlassian/lighthouse/frontend/security/UserAuthorizationService;Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;Lcom/atlassian/lighthouse/frontend/services/ProductInfoService;Lcom/atlassian/sal/api/websudo/WebSudoManager;)V", "doGet", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "render", "renderInAdminSection", "", "sendUnauthorizedResponse", "Companion", "atlassian-lighthouse-frontend"})
@SourceDebugExtension(value={"SMAP\nLighthouseAdminServlet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LighthouseAdminServlet.kt\ncom/atlassian/lighthouse/frontend/LighthouseAdminServlet\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,123:1\n11#2:124\n10#2,3:125\n*S KotlinDebug\n*F\n+ 1 LighthouseAdminServlet.kt\ncom/atlassian/lighthouse/frontend/LighthouseAdminServlet\n*L\n42#1:124\n42#1:125,3\n*E\n"})
public class LighthouseAdminServlet
extends HttpServlet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PageBuilderService pageBuilderService;
    @NotNull
    private final SoyTemplateRenderer soyTemplateRenderer;
    @NotNull
    private final PermissionEnforcer permissionEnforcer;
    @NotNull
    private final LoginUriProvider loginUriProvider;
    @NotNull
    private final LighthouseAdminDataProvider lighthouseAdminDataProvider;
    @NotNull
    private final UserAuthorizationService userAuthorizationService;
    @NotNull
    private final WebSudoEnforcerService webSudoEnforcerService;
    @NotNull
    private final ProductInfoService productInfoService;
    @NotNull
    private final WebSudoManager webSudoManager;
    @NotNull
    private static final Logger logger;
    private static final String BUNDLE_NAME;
    @NotNull
    private static final String ENTRYPOINT_RESOURCE_KEY;
    @NotNull
    private static final String SOY_TEMPLATE_RESOURCE_KEY;
    @NotNull
    private static final String ADMIN_DATA_KEY;
    @NotNull
    private static final String SOY_TEMPLATE_ENTRYPOINT_NAME = "atlassian.lighthouse.entrypoint";

    @Inject
    public LighthouseAdminServlet(@NotNull PageBuilderService pageBuilderService, @NotNull SoyTemplateRenderer soyTemplateRenderer, @NotNull PermissionEnforcer permissionEnforcer, @NotNull LoginUriProvider loginUriProvider, @NotNull LighthouseAdminDataProvider lighthouseAdminDataProvider, @NotNull UserAuthorizationService userAuthorizationService, @NotNull WebSudoEnforcerService webSudoEnforcerService, @NotNull ProductInfoService productInfoService, @NotNull WebSudoManager webSudoManager) {
        Intrinsics.checkNotNullParameter(pageBuilderService, "pageBuilderService");
        Intrinsics.checkNotNullParameter(soyTemplateRenderer, "soyTemplateRenderer");
        Intrinsics.checkNotNullParameter(permissionEnforcer, "permissionEnforcer");
        Intrinsics.checkNotNullParameter(loginUriProvider, "loginUriProvider");
        Intrinsics.checkNotNullParameter(lighthouseAdminDataProvider, "lighthouseAdminDataProvider");
        Intrinsics.checkNotNullParameter(userAuthorizationService, "userAuthorizationService");
        Intrinsics.checkNotNullParameter(webSudoEnforcerService, "webSudoEnforcerService");
        Intrinsics.checkNotNullParameter(productInfoService, "productInfoService");
        Intrinsics.checkNotNullParameter(webSudoManager, "webSudoManager");
        this.pageBuilderService = pageBuilderService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.permissionEnforcer = permissionEnforcer;
        this.loginUriProvider = loginUriProvider;
        this.lighthouseAdminDataProvider = lighthouseAdminDataProvider;
        this.userAuthorizationService = userAuthorizationService;
        this.webSudoEnforcerService = webSudoEnforcerService;
        this.productInfoService = productInfoService;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(response, "response");
        try {
            this.webSudoEnforcerService.enforceWebSudoIfApplicable(request);
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        try {
            boolean isAuthenticated = this.permissionEnforcer.isAuthenticated();
            boolean isAuthorized = this.userAuthorizationService.isCurrentUserAuthorizedToViewLighthouseServlet();
            boolean renderInAdminSection = this.permissionEnforcer.isAdmin() || this.permissionEnforcer.isSystemAdmin();
            if (isAuthorized) {
                this.render(response, renderInAdminSection);
            } else if (isAuthenticated) {
                this.sendUnauthorizedResponse(response);
            } else {
                response.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(request.getRequestURL().toString())).toASCIIString());
            }
        }
        catch (IOException exception) {
            logger.error("Unable to render template", (Throwable)exception);
            response.sendError(500);
        }
    }

    private final void render(HttpServletResponse response, boolean renderInAdminSection) {
        response.setContentType("text/html");
        this.pageBuilderService.assembler().resources().requireWebResource(ResourcePhase.REQUIRE, ENTRYPOINT_RESOURCE_KEY);
        this.pageBuilderService.assembler().data().requireData(ADMIN_DATA_KEY, this.lighthouseAdminDataProvider.get());
        Pair[] pairArray = new Pair[]{TuplesKt.to("adminDataKey", ADMIN_DATA_KEY), TuplesKt.to("renderInAdminSection", renderInAdminSection), TuplesKt.to("isConfluence", this.productInfoService.isConfluence())};
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), SOY_TEMPLATE_RESOURCE_KEY, SOY_TEMPLATE_ENTRYPOINT_NAME, MapsKt.mapOf(pairArray));
    }

    private final void sendUnauthorizedResponse(HttpServletResponse response) {
        if (this.productInfoService.isBitbucket()) {
            response.sendError(401);
            return;
        }
        if (this.productInfoService.isConfluence()) {
            throw new AuthorisationException();
        }
        response.sendError(403);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        LighthouseAdminServlet.logger = logger;
        BUNDLE_NAME = OsgiHeaderUtil.getPluginKey((Bundle)FrameworkUtil.getBundle(LighthouseAdminServlet.class));
        ENTRYPOINT_RESOURCE_KEY = BUNDLE_NAME + ":entrypoint-admin-entrypoint";
        SOY_TEMPLATE_RESOURCE_KEY = BUNDLE_NAME + ":admin-ui-templates";
        ADMIN_DATA_KEY = BUNDLE_NAME + ":wrm-admin-data";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/lighthouse/frontend/LighthouseAdminServlet$Companion;", "", "()V", "ADMIN_DATA_KEY", "", "BUNDLE_NAME", "kotlin.jvm.PlatformType", "ENTRYPOINT_RESOURCE_KEY", "SOY_TEMPLATE_ENTRYPOINT_NAME", "SOY_TEMPLATE_RESOURCE_KEY", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

