/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.frontend.config;

import com.atlassian.lighthouse.config.CoreBeanConfig;
import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.frontend.conditions.UserIsAuthorizedToViewLighthouseCondition;
import com.atlassian.lighthouse.frontend.config.ConfluenceFrontendBeansConfig;
import com.atlassian.lighthouse.frontend.config.JiraFrontendBeansConfig;
import com.atlassian.lighthouse.frontend.config.RefappFrontendBeansConfig;
import com.atlassian.lighthouse.frontend.data.LighthouseAdminDataProvider;
import com.atlassian.lighthouse.frontend.data.WrmDataObjectMapper;
import com.atlassian.lighthouse.frontend.security.UserAuthorizationService;
import com.atlassian.lighthouse.frontend.services.ProductInfoService;
import com.atlassian.lighthouse.plugin.PluginInfo;
import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagService;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={JiraFrontendBeansConfig.class, ConfluenceFrontendBeansConfig.class, RefappFrontendBeansConfig.class, CoreBeanConfig.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017JH\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006#"}, d2={"Lcom/atlassian/lighthouse/frontend/config/FrontendBeansConfig;", "", "()V", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "lighthouseAdminDataProvider", "Lcom/atlassian/lighthouse/frontend/data/LighthouseAdminDataProvider;", "featureFlagService", "Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;", "wrmDataObjectMapper", "Lcom/atlassian/lighthouse/frontend/data/WrmDataObjectMapper;", "localeResolver", "Lcom/atlassian/sal/api/message/LocaleResolver;", "productInfoService", "Lcom/atlassian/lighthouse/frontend/services/ProductInfoService;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "loginUriProvider", "Lcom/atlassian/sal/api/auth/LoginUriProvider;", "pageBuilderService", "Lcom/atlassian/webresource/api/assembler/PageBuilderService;", "permissionEnforcer", "Lcom/atlassian/sal/api/permission/PermissionEnforcer;", "soyTemplateRenderer", "Lcom/atlassian/soy/renderer/SoyTemplateRenderer;", "userAuthorizationService", "Lcom/atlassian/lighthouse/frontend/security/UserAuthorizationService;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "userIsAuthorizedToViewLighthouseCondition", "Lcom/atlassian/lighthouse/frontend/conditions/UserIsAuthorizedToViewLighthouseCondition;", "atlassian-lighthouse-frontend"})
public class FrontendBeansConfig {
    @Bean
    @NotNull
    public ApplicationProperties applicationProperties() {
        ApplicationProperties applicationProperties = OsgiServices.importOsgiService(ApplicationProperties.class);
        Intrinsics.checkNotNullExpressionValue(applicationProperties, "importOsgiService(...)");
        return applicationProperties;
    }

    @Bean
    @NotNull
    public LoginUriProvider loginUriProvider() {
        LoginUriProvider loginUriProvider = OsgiServices.importOsgiService(LoginUriProvider.class);
        Intrinsics.checkNotNullExpressionValue(loginUriProvider, "importOsgiService(...)");
        return loginUriProvider;
    }

    @Bean
    @NotNull
    public PageBuilderService pageBuilderService() {
        PageBuilderService pageBuilderService = OsgiServices.importOsgiService(PageBuilderService.class);
        Intrinsics.checkNotNullExpressionValue(pageBuilderService, "importOsgiService(...)");
        return pageBuilderService;
    }

    @Bean
    @NotNull
    public PermissionEnforcer permissionEnforcer() {
        PermissionEnforcer permissionEnforcer = OsgiServices.importOsgiService(PermissionEnforcer.class);
        Intrinsics.checkNotNullExpressionValue(permissionEnforcer, "importOsgiService(...)");
        return permissionEnforcer;
    }

    @Bean
    @NotNull
    public SoyTemplateRenderer soyTemplateRenderer() {
        SoyTemplateRenderer soyTemplateRenderer = OsgiServices.importOsgiService(SoyTemplateRenderer.class);
        Intrinsics.checkNotNullExpressionValue(soyTemplateRenderer, "importOsgiService(...)");
        return soyTemplateRenderer;
    }

    @Bean
    @NotNull
    public LocaleResolver localeResolver() {
        LocaleResolver localeResolver = OsgiServices.importOsgiService(LocaleResolver.class);
        Intrinsics.checkNotNullExpressionValue(localeResolver, "importOsgiService(...)");
        return localeResolver;
    }

    @Bean
    @NotNull
    public TimeZoneManager timeZoneManager() {
        TimeZoneManager timeZoneManager = OsgiServices.importOsgiService(TimeZoneManager.class);
        Intrinsics.checkNotNullExpressionValue(timeZoneManager, "importOsgiService(...)");
        return timeZoneManager;
    }

    @Bean
    @NotNull
    public UserManager userManager() {
        UserManager userManager = OsgiServices.importOsgiService(UserManager.class);
        Intrinsics.checkNotNullExpressionValue(userManager, "importOsgiService(...)");
        return userManager;
    }

    @Bean
    @NotNull
    public WrmDataObjectMapper wrmDataObjectMapper() {
        return new WrmDataObjectMapper();
    }

    @Bean
    @NotNull
    public UserAuthorizationService userAuthorizationService(@NotNull PermissionEnforcer permissionEnforcer, @NotNull UserManager userManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(permissionEnforcer, "permissionEnforcer");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new UserAuthorizationService(permissionEnforcer, userManager, lighthouseConfig.getSecurityGroupName());
    }

    @Bean
    @NotNull
    public UserIsAuthorizedToViewLighthouseCondition userIsAuthorizedToViewLighthouseCondition(@NotNull UserAuthorizationService userAuthorizationService) {
        Intrinsics.checkNotNullParameter(userAuthorizationService, "userAuthorizationService");
        return new UserIsAuthorizedToViewLighthouseCondition(userAuthorizationService);
    }

    @Bean
    @NotNull
    public LighthouseAdminDataProvider lighthouseAdminDataProvider(@NotNull ApplicationProperties applicationProperties, @NotNull FeatureFlagService featureFlagService, @NotNull WrmDataObjectMapper wrmDataObjectMapper, @NotNull LocaleResolver localeResolver, @NotNull ProductInfoService productInfoService, @NotNull TimeZoneManager timeZoneManager, @NotNull UserManager userManager, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        Intrinsics.checkNotNullParameter(featureFlagService, "featureFlagService");
        Intrinsics.checkNotNullParameter((Object)wrmDataObjectMapper, "wrmDataObjectMapper");
        Intrinsics.checkNotNullParameter(localeResolver, "localeResolver");
        Intrinsics.checkNotNullParameter(productInfoService, "productInfoService");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        return new LighthouseAdminDataProvider(applicationProperties, featureFlagService, wrmDataObjectMapper, localeResolver, productInfoService, timeZoneManager, userManager, pluginInfo);
    }
}

