/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.frontend.security;

import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/lighthouse/frontend/security/UserAuthorizationService;", "", "permissionEnforcer", "Lcom/atlassian/sal/api/permission/PermissionEnforcer;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "securityGroupName", "", "(Lcom/atlassian/sal/api/permission/PermissionEnforcer;Lcom/atlassian/sal/api/user/UserManager;Ljava/lang/String;)V", "isCurrentUserAuthorizedToViewLighthouseServlet", "", "atlassian-lighthouse-frontend"})
@SourceDebugExtension(value={"SMAP\nUserAuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAuthorizationService.kt\ncom/atlassian/lighthouse/frontend/security/UserAuthorizationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,19:1\n1#2:20\n*E\n"})
public final class UserAuthorizationService {
    @NotNull
    private final PermissionEnforcer permissionEnforcer;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final String securityGroupName;

    public UserAuthorizationService(@NotNull PermissionEnforcer permissionEnforcer, @NotNull UserManager userManager, @NotNull String securityGroupName) {
        Intrinsics.checkNotNullParameter(permissionEnforcer, "permissionEnforcer");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(securityGroupName, "securityGroupName");
        this.permissionEnforcer = permissionEnforcer;
        this.userManager = userManager;
        this.securityGroupName = securityGroupName;
    }

    public final boolean isCurrentUserAuthorizedToViewLighthouseServlet() {
        UserKey it = this.userManager.getRemoteUserKey();
        boolean bl = false;
        boolean isInSecurityGroup = this.userManager.isUserInGroup(it, this.securityGroupName);
        boolean isAuthorized = this.permissionEnforcer.isAuthenticated() && (this.permissionEnforcer.isSystemAdmin() || isInSecurityGroup);
        return isAuthorized;
    }
}

