/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.i18n;

import com.atlassian.lighthouse.i18n.AlertTypeI18nMapper;
import com.atlassian.lighthouse.i18n.EmailAlertTypeI18nMapper;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\tH\u0016R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/i18n/EmailAlertTypeI18nMapper;", "Lcom/atlassian/lighthouse/i18n/AlertTypeI18nMapper;", "", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "(Lcom/atlassian/sal/api/message/I18nResolver;)V", "i18nKeyMap", "Lkotlin/Lazy;", "", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "getI18nKey", "type", "getTranslation", "atlassian-lighthouse-core"})
public final class EmailAlertTypeI18nMapper
implements AlertTypeI18nMapper<String> {
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final Lazy<Map<AlertType, String>> i18nKeyMap;

    public EmailAlertTypeI18nMapper(@NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        this.i18nResolver = i18nResolver;
        this.i18nKeyMap = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)i18nKeyMap.1.INSTANCE);
    }

    @NotNull
    public final String getI18nKey(@NotNull AlertType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        String string = this.i18nKeyMap.getValue().get((Object)type);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected alert type " + type + ", make sure you don't mock AlertType enum values.");
        }
        return string;
    }

    @Override
    @NotNull
    public String getTranslation(@NotNull AlertType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        String i18nKey = this.getI18nKey(type);
        String string = this.i18nResolver.getText(i18nKey);
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return string;
    }
}

