/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.notification.AuditNotificationEventPublisher;
import com.atlassian.lighthouse.notification.template.CommonTemplateParameter;
import com.atlassian.lighthouse.notification.template.MailTemplate;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J!\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00152\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/lighthouse/notification/AuditNotificationService;", "", "auditNotificationEventPublisher", "Lcom/atlassian/lighthouse/notification/AuditNotificationEventPublisher;", "auditService", "Lcom/atlassian/audit/api/AuditService;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "(Lcom/atlassian/lighthouse/notification/AuditNotificationEventPublisher;Lcom/atlassian/audit/api/AuditService;Lcom/atlassian/sal/api/message/I18nResolver;)V", "audit", "", "auditType", "Lcom/atlassian/audit/entity/AuditType;", "extraAttributes", "", "Lcom/atlassian/audit/entity/AuditAttribute;", "auditNotificationFailed", "alertEntity", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "recipientAddresses", "", "", "(Lcom/atlassian/lighthouse/database/entities/AlertEntity;[Ljava/lang/String;)V", "auditNotificationSent", "template", "Lcom/atlassian/lighthouse/notification/template/MailTemplate;", "(Lcom/atlassian/lighthouse/notification/template/MailTemplate;[Ljava/lang/String;)V", "buildExtraAttributes", "(Lcom/atlassian/lighthouse/database/entities/AlertEntity;[Ljava/lang/String;)Ljava/util/List;", "(Lcom/atlassian/lighthouse/notification/template/MailTemplate;[Ljava/lang/String;)Ljava/util/List;", "renderAlertSpecificAttributes", "attributeValue", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAuditNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditNotificationService.kt\ncom/atlassian/lighthouse/notification/AuditNotificationService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,136:1\n125#2:137\n152#2,3:138\n125#2:141\n152#2,3:142\n*S KotlinDebug\n*F\n+ 1 AuditNotificationService.kt\ncom/atlassian/lighthouse/notification/AuditNotificationService\n*L\n86#1:137\n86#1:138,3\n93#1:141\n93#1:142,3\n*E\n"})
public final class AuditNotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuditNotificationEventPublisher auditNotificationEventPublisher;
    @NotNull
    private final AuditService auditService;
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private static final String I18N_PREFIX = "lighthouse.email";
    @NotNull
    private static final String ALERT_NAME_I18N_KEY = "lighthouse.email.label.alertName";
    @NotNull
    private static final String ALERT_ID_I18N_KEY = "lighthouse.email.label.alertId";
    @NotNull
    private static final String ALERT_UUID_I18N_KEY = "lighthouse.email.label.alertUUID";
    @NotNull
    private static final String EMAIL_RECIPIENTS_I18N_KEY = "lighthouse.email.notification.recipients";
    @NotNull
    private static final String EMAIL_SUBJECT_I18N_KEY = "lighthouse.email.label.subject";
    @NotNull
    private static final AuditType EMAIL_SENT_AUDIT_TYPE = com.atlassian.lighthouse.notification.AuditNotificationService$Companion.access$createAuditType(Companion, "lighthouse.email.notification.action.sent");
    @NotNull
    private static final AuditType EMAIL_FAILED_AUDIT_TYPE = com.atlassian.lighthouse.notification.AuditNotificationService$Companion.access$createAuditType(Companion, "lighthouse.email.notification.action.failed");
    @NotNull
    private static final String RECIPIENT_ADDRESS_SEPARATOR = ", ";

    public AuditNotificationService(@NotNull AuditNotificationEventPublisher auditNotificationEventPublisher, @NotNull AuditService auditService, @NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(auditNotificationEventPublisher, "auditNotificationEventPublisher");
        Intrinsics.checkNotNullParameter(auditService, "auditService");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        this.auditNotificationEventPublisher = auditNotificationEventPublisher;
        this.auditService = auditService;
        this.i18nResolver = i18nResolver;
    }

    public final void auditNotificationSent(@NotNull MailTemplate template, @NotNull String[] recipientAddresses) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(recipientAddresses, "recipientAddresses");
        List<AuditAttribute> extraAttributes = this.buildExtraAttributes(template, recipientAddresses);
        this.audit(EMAIL_SENT_AUDIT_TYPE, extraAttributes);
    }

    public final void auditNotificationFailed(@NotNull AlertEntity alertEntity, @NotNull String[] recipientAddresses) {
        Intrinsics.checkNotNullParameter(alertEntity, "alertEntity");
        Intrinsics.checkNotNullParameter(recipientAddresses, "recipientAddresses");
        List<AuditAttribute> extraAttributes = this.buildExtraAttributes(alertEntity, recipientAddresses);
        this.audit(EMAIL_FAILED_AUDIT_TYPE, extraAttributes);
        this.auditNotificationEventPublisher.publishAuditNotificationFailedAnalyticEvent(alertEntity.getAlertType().getId(), alertEntity.getUuid());
    }

    @VisibleForTesting
    public final void audit(@NotNull AuditType auditType, @NotNull List<? extends AuditAttribute> extraAttributes) {
        Intrinsics.checkNotNullParameter(auditType, "auditType");
        Intrinsics.checkNotNullParameter(extraAttributes, "extraAttributes");
        AuditEvent auditEvent = AuditEvent.builder((AuditType)auditType).extraAttributes((Collection)extraAttributes).build();
        this.auditService.audit(auditEvent);
    }

    @VisibleForTesting
    @NotNull
    public final List<AuditAttribute> buildExtraAttributes(@NotNull MailTemplate template, @NotNull String[] recipientAddresses) {
        Map.Entry<Object, Object> it;
        boolean bl;
        Collection collection;
        Map<Enum, Object> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(recipientAddresses, "recipientAddresses");
        AuditAttribute alertName = AuditAttribute.fromI18nKeys((String)ALERT_NAME_I18N_KEY, (String)template.getAlertType().getId()).build();
        AuditAttribute alertId = AuditAttribute.fromI18nKeys((String)ALERT_ID_I18N_KEY, (String)template.getAlertId()).build();
        AuditAttribute alertUUID = AuditAttribute.fromI18nKeys((String)ALERT_UUID_I18N_KEY, (String)template.getAlertUUID()).build();
        AuditAttribute subject = AuditAttribute.fromI18nKeys((String)EMAIL_SUBJECT_I18N_KEY, (String)template.getSubject()).build();
        AuditAttribute recipients = AuditAttribute.fromI18nKeys((String)EMAIL_RECIPIENTS_I18N_KEY, (String)ArraysKt.joinToString$default(recipientAddresses, (CharSequence)RECIPIENT_ADDRESS_SEPARATOR, null, null, 0, null, null, 62, null)).build();
        Map<Enum, Object> $this$map$iv = template.getCommonRenderingParameters();
        boolean $i$f$map = false;
        Map<CommonTemplateParameter, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<Object, Object>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            collection = destination$iv$iv;
            bl = false;
            collection.add(AuditAttribute.fromI18nKeys((String)("lighthouse.email.label." + it.getKey()), (String)((String)it.getValue())).build());
        }
        $this$map$iv = template.getAlertSpecificRenderingParameters();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, Object> entry;
            it = entry = iterator2.next();
            Collection collection2 = destination$iv$iv;
            bl = false;
            collection2.add(AuditAttribute.fromI18nKeys((String)("lighthouse.email.label." + it.getKey()), (String)this.renderAlertSpecificAttributes((List)it.getValue())).build());
        }
        List parameterAttributes = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        AuditAttribute[] auditAttributeArray = new AuditAttribute[]{alertName, alertId, alertUUID, subject, recipients};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(auditAttributeArray), (Iterable)parameterAttributes);
    }

    @VisibleForTesting
    @NotNull
    public final List<AuditAttribute> buildExtraAttributes(@NotNull AlertEntity alertEntity, @NotNull String[] recipientAddresses) {
        Intrinsics.checkNotNullParameter(alertEntity, "alertEntity");
        Intrinsics.checkNotNullParameter(recipientAddresses, "recipientAddresses");
        AuditAttribute alertName = AuditAttribute.fromI18nKeys((String)ALERT_NAME_I18N_KEY, (String)alertEntity.getAlertType().getId()).build();
        AuditAttribute alertId = AuditAttribute.fromI18nKeys((String)ALERT_ID_I18N_KEY, (String)String.valueOf(alertEntity.getId())).build();
        AuditAttribute alertUUID = AuditAttribute.fromI18nKeys((String)ALERT_UUID_I18N_KEY, (String)alertEntity.getUuid()).build();
        AuditAttribute recipients = AuditAttribute.fromI18nKeys((String)EMAIL_RECIPIENTS_I18N_KEY, (String)ArraysKt.joinToString$default(recipientAddresses, (CharSequence)RECIPIENT_ADDRESS_SEPARATOR, null, null, 0, null, null, 62, null)).build();
        AuditAttribute[] auditAttributeArray = new AuditAttribute[]{alertName, alertId, alertUUID, recipients};
        return CollectionsKt.listOf(auditAttributeArray);
    }

    private final String renderAlertSpecificAttributes(List<String> attributeValue) {
        String string;
        Integer n;
        List<String> list = attributeValue;
        Integer n2 = n = list != null ? Integer.valueOf(list.size()) : null;
        if (n2 == null ? true : n2 == 0) {
            string = "";
        } else {
            Integer n3 = n;
            int n4 = 1;
            if (n3 != null && n3 == n4) {
                string = attributeValue.get(0);
            } else {
                Serializable[] serializableArray = new Serializable[]{attributeValue.get(0), attributeValue.get(1)};
                String string2 = this.i18nResolver.getText("lighthouse.email.label.oldAndNewValuesTemplate", serializableArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/notification/AuditNotificationService$Companion;", "", "()V", "ALERT_ID_I18N_KEY", "", "ALERT_NAME_I18N_KEY", "ALERT_UUID_I18N_KEY", "EMAIL_FAILED_AUDIT_TYPE", "Lcom/atlassian/audit/entity/AuditType;", "EMAIL_RECIPIENTS_I18N_KEY", "EMAIL_SENT_AUDIT_TYPE", "EMAIL_SUBJECT_I18N_KEY", "I18N_PREFIX", "RECIPIENT_ADDRESS_SEPARATOR", "createAuditType", "key", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        private final AuditType createAuditType(String key) {
            AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"lighthouse.email.notification.category", (String)key).build();
            Intrinsics.checkNotNullExpressionValue(auditType, "build(...)");
            return auditType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ AuditType access$createAuditType(Companion $this, String key) {
            return $this.createAuditType(key);
        }
    }
}

