/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification.mail;

import com.atlassian.lighthouse.notification.generators.DefaultEmailFactory;
import com.atlassian.lighthouse.notification.mail.MailServiceInterface;
import com.atlassian.lighthouse.notification.template.MailTemplate;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.Settings;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/notification/mail/JiraMailService;", "Lcom/atlassian/lighthouse/notification/mail/MailServiceInterface;", "mailQueue", "Lcom/atlassian/mail/queue/MailQueue;", "defaultEmailFactory", "Lcom/atlassian/lighthouse/notification/generators/DefaultEmailFactory;", "(Lcom/atlassian/mail/queue/MailQueue;Lcom/atlassian/lighthouse/notification/generators/DefaultEmailFactory;)V", "sendMail", "", "template", "Lcom/atlassian/lighthouse/notification/template/MailTemplate;", "emailAddresses", "", "", "(Lcom/atlassian/lighthouse/notification/template/MailTemplate;[Ljava/lang/String;)V", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nJiraMailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraMailService.kt\ncom/atlassian/lighthouse/notification/mail/JiraMailService\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,31:1\n11#2:32\n10#2,3:33\n*S KotlinDebug\n*F\n+ 1 JiraMailService.kt\ncom/atlassian/lighthouse/notification/mail/JiraMailService\n*L\n15#1:32\n15#1:33,3\n*E\n"})
public final class JiraMailService
implements MailServiceInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MailQueue mailQueue;
    @NotNull
    private final DefaultEmailFactory defaultEmailFactory;
    @NotNull
    private static final Logger logger;

    public JiraMailService(@NotNull MailQueue mailQueue, @NotNull DefaultEmailFactory defaultEmailFactory) {
        Intrinsics.checkNotNullParameter(mailQueue, "mailQueue");
        Intrinsics.checkNotNullParameter(defaultEmailFactory, "defaultEmailFactory");
        this.mailQueue = mailQueue;
        this.defaultEmailFactory = defaultEmailFactory;
    }

    @Override
    public void sendMail(@NotNull MailTemplate template, @NotNull String[] emailAddresses) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(emailAddresses, "emailAddresses");
        Email email = this.defaultEmailFactory.createEmail(template, emailAddresses);
        MailServerManager mailServerManager = MailFactory.getServerManager();
        Settings settings = MailFactory.getSettings();
        SingleMailQueueItem singleMailQueueItem = new SingleMailQueueItem(email, mailServerManager, settings);
        logger.info("[Atlassian Lighthouse] - adding mail to queue {}", (Object)singleMailQueueItem);
        this.mailQueue.addItem((MailQueueItem)singleMailQueueItem);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        JiraMailService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/notification/mail/JiraMailService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

