/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification.template;

import com.atlassian.lighthouse.i18n.EmailAlertTypeI18nMapper;
import com.atlassian.lighthouse.notification.template.CommonTemplateParameter;
import com.atlassian.lighthouse.notification.template.MailTemplate;
import com.atlassian.lighthouse.notification.template.TemplateParameter;
import com.atlassian.lighthouse.resource.EmailResourceProvider;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u0002H\u000f\u0012\u0002\b\u00030\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/notification/template/MailTemplateRenderer;", "", "alertTypeI18nMapper", "Lcom/atlassian/lighthouse/i18n/EmailAlertTypeI18nMapper;", "soyTemplateRenderer", "Lcom/atlassian/soy/renderer/SoyTemplateRenderer;", "emailResourceProvider", "Lcom/atlassian/lighthouse/resource/EmailResourceProvider;", "(Lcom/atlassian/lighthouse/i18n/EmailAlertTypeI18nMapper;Lcom/atlassian/soy/renderer/SoyTemplateRenderer;Lcom/atlassian/lighthouse/resource/EmailResourceProvider;)V", "getRenderingParams", "", "", "mailTemplate", "Lcom/atlassian/lighthouse/notification/template/MailTemplate;", "mapKeysToString", "T", "Lcom/atlassian/lighthouse/notification/template/TemplateParameter;", "mapWithKeysToConvert", "render", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nMailTemplateRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailTemplateRenderer.kt\ncom/atlassian/lighthouse/notification/template/MailTemplateRenderer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,45:1\n125#2:46\n152#2,3:47\n*S KotlinDebug\n*F\n+ 1 MailTemplateRenderer.kt\ncom/atlassian/lighthouse/notification/template/MailTemplateRenderer\n*L\n42#1:46\n42#1:47,3\n*E\n"})
public final class MailTemplateRenderer {
    @NotNull
    private final EmailAlertTypeI18nMapper alertTypeI18nMapper;
    @NotNull
    private final SoyTemplateRenderer soyTemplateRenderer;
    @NotNull
    private final EmailResourceProvider emailResourceProvider;

    public MailTemplateRenderer(@NotNull EmailAlertTypeI18nMapper alertTypeI18nMapper, @NotNull SoyTemplateRenderer soyTemplateRenderer, @NotNull EmailResourceProvider emailResourceProvider) {
        Intrinsics.checkNotNullParameter(alertTypeI18nMapper, "alertTypeI18nMapper");
        Intrinsics.checkNotNullParameter(soyTemplateRenderer, "soyTemplateRenderer");
        Intrinsics.checkNotNullParameter(emailResourceProvider, "emailResourceProvider");
        this.alertTypeI18nMapper = alertTypeI18nMapper;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.emailResourceProvider = emailResourceProvider;
    }

    @NotNull
    public final String render(@NotNull MailTemplate mailTemplate) {
        Intrinsics.checkNotNullParameter(mailTemplate, "mailTemplate");
        String string = this.soyTemplateRenderer.render(mailTemplate.getSoyTemplateModuleKey(), mailTemplate.getSoyTemplateName(), this.getRenderingParams(mailTemplate));
        Intrinsics.checkNotNullExpressionValue(string, "render(...)");
        return string;
    }

    private final Map<String, Object> getRenderingParams(MailTemplate mailTemplate) {
        Pair[] pairArray = new Pair[]{TuplesKt.to(CommonTemplateParameter.ALERT_TYPE.getId(), this.alertTypeI18nMapper.getI18nKey(mailTemplate.getAlertType())), TuplesKt.to(CommonTemplateParameter.ALERT_ID.getId(), mailTemplate.getAlertId()), TuplesKt.to(CommonTemplateParameter.ALERT_UUID.getId(), mailTemplate.getAlertUUID()), TuplesKt.to(CommonTemplateParameter.ALERT_SPECIFIC_LABEL_TO_VALUE_MAP.getId(), this.mapKeysToString(mailTemplate.getAlertSpecificRenderingParameters())), TuplesKt.to(CommonTemplateParameter.COMMON_LABEL_TO_VALUE_MAP.getId(), this.mapKeysToString(mailTemplate.getCommonRenderingParameters())), TuplesKt.to(CommonTemplateParameter.LOGO_URL.getId(), this.emailResourceProvider.getLogoUrl()), TuplesKt.to(CommonTemplateParameter.RIGHT_ARROW_ICON_URL.getId(), this.emailResourceProvider.getArrowRightIconUrl())};
        return MapsKt.mapOf(pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends TemplateParameter> Map<String, Object> mapKeysToString(Map<T, ?> mapWithKeysToConvert) {
        void $this$mapTo$iv$iv;
        Map<T, ?> $this$map$iv = mapWithKeysToConvert;
        boolean $i$f$map = false;
        Map<T, ?> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(((TemplateParameter)it.getKey()).getId(), it.getValue()));
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }
}

