/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/plugin/PluginInfo;", "", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "(Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/sal/api/ApplicationProperties;)V", "isProductionRelease", "", "()Z", "pluginVersion", "", "getPluginVersion", "()Ljava/lang/String;", "productId", "getProductId", "productVersion", "getProductVersion", "getBundleName", "atlassian-lighthouse-core"})
public final class PluginInfo {
    private final boolean isProductionRelease;
    @NotNull
    private final String pluginVersion;
    @NotNull
    private final String productId;
    @NotNull
    private final String productVersion;

    public PluginInfo(@NotNull PluginAccessor pluginAccessor, @NotNull ApplicationProperties applicationProperties) {
        Intrinsics.checkNotNullParameter(pluginAccessor, "pluginAccessor");
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        String rawPluginVersion = pluginAccessor.getPlugin(this.getBundleName()).getPluginInformation().getVersion();
        Intrinsics.checkNotNull(rawPluginVersion);
        CharSequence charSequence = rawPluginVersion;
        this.isProductionRelease = !new Regex("[A-Za-z]").containsMatchIn(charSequence);
        charSequence = rawPluginVersion;
        Regex regex = new Regex("[^0-9.]");
        String string = "";
        this.pluginVersion = regex.replace(charSequence, string);
        String string2 = applicationProperties.getDisplayName();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        this.productId = string3;
        String string4 = applicationProperties.getVersion();
        Intrinsics.checkNotNullExpressionValue(string4, "getVersion(...)");
        this.productVersion = string4;
    }

    public final boolean isProductionRelease() {
        return this.isProductionRelease;
    }

    @NotNull
    public final String getPluginVersion() {
        return this.pluginVersion;
    }

    @NotNull
    public final String getProductId() {
        return this.productId;
    }

    @NotNull
    public final String getProductVersion() {
        return this.productVersion;
    }

    @NotNull
    public final String getBundleName() {
        String string = OsgiHeaderUtil.getPluginKey((Bundle)FrameworkUtil.getBundle(this.getClass()));
        Intrinsics.checkNotNullExpressionValue(string, "getPluginKey(...)");
        return string;
    }
}

