/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.resource;

import com.atlassian.lighthouse.plugin.PluginInfo;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u0004\u0018\u00010\bJ\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/resource/EmailResourceProvider;", "", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "webResourceUrlProvider", "Lcom/atlassian/webresource/api/WebResourceUrlProvider;", "(Lcom/atlassian/lighthouse/plugin/PluginInfo;Lcom/atlassian/webresource/api/WebResourceUrlProvider;)V", "iconModuleKey", "", "logoModuleKey", "getArrowRightIconUrl", "getLogoUrl", "getStaticPluginResourceUrl", "key", "resourceName", "tryToGetIconUrl", "iconName", "tryToGetLogoUrl", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nEmailResourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailResourceProvider.kt\ncom/atlassian/lighthouse/resource/EmailResourceProvider\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,63:1\n11#2:64\n10#2,3:65\n*S KotlinDebug\n*F\n+ 1 EmailResourceProvider.kt\ncom/atlassian/lighthouse/resource/EmailResourceProvider\n*L\n60#1:64\n60#1:65,3\n*E\n"})
public final class EmailResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginInfo pluginInfo;
    @NotNull
    private final WebResourceUrlProvider webResourceUrlProvider;
    @NotNull
    private final String iconModuleKey;
    @NotNull
    private final String logoModuleKey;
    @NotNull
    private static final Logger logger;

    public EmailResourceProvider(@NotNull PluginInfo pluginInfo, @NotNull WebResourceUrlProvider webResourceUrlProvider) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(webResourceUrlProvider, "webResourceUrlProvider");
        this.pluginInfo = pluginInfo;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.iconModuleKey = this.pluginInfo.getBundleName() + ":lighthouse-icon-resources";
        this.logoModuleKey = this.pluginInfo.getBundleName() + ":lighthouse-logo-resources";
    }

    @Nullable
    public final String getLogoUrl() {
        return this.tryToGetLogoUrl();
    }

    @Nullable
    public final String getArrowRightIconUrl() {
        return this.tryToGetIconUrl("arrowRightIcon");
    }

    private final String tryToGetLogoUrl() {
        String string;
        try {
            string = this.getStaticPluginResourceUrl(this.logoModuleKey, "logos/" + this.pluginInfo.getProductId() + ".png");
        }
        catch (Error e) {
            logger.error("Exception in retrieving static resource url for logo of product ID: " + this.pluginInfo.getProductId(), (Throwable)e);
            string = null;
        }
        return string;
    }

    private final String tryToGetIconUrl(String iconName) {
        String string;
        try {
            string = this.getStaticPluginResourceUrl(this.iconModuleKey, "icons/" + iconName + ".png");
        }
        catch (Error e) {
            logger.error("Exception in retrieving static resource url for icon: " + iconName + " of product ID: " + this.pluginInfo.getProductId(), (Throwable)e);
            string = null;
        }
        return string;
    }

    private final String getStaticPluginResourceUrl(String key, String resourceName) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(key, resourceName, UrlMode.ABSOLUTE);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        EmailResourceProvider.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/resource/EmailResourceProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

