/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest;

import com.atlassian.lighthouse.database.dao.AlertManager;
import com.atlassian.lighthouse.database.dao.AlertsPage;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.query.AlertsQuery;
import com.atlassian.lighthouse.database.query.AlertsQueryTextSearchComponents;
import com.atlassian.lighthouse.database.query.Cursor;
import com.atlassian.lighthouse.database.query.PageRequest;
import com.atlassian.lighthouse.rest.AlertsCursor;
import com.atlassian.lighthouse.rest.GetAlertsBeanParam;
import com.atlassian.lighthouse.rest.RestObjectMapper;
import com.atlassian.lighthouse.rest.dto.AlertDto;
import com.atlassian.lighthouse.rest.dto.BulkUpdateAlertStatusRequestDto;
import com.atlassian.lighthouse.rest.dto.BulkUpdateAlertStatusResponseDto;
import com.atlassian.lighthouse.rest.dto.GetAlertsResponseDto;
import com.atlassian.lighthouse.rest.dto.LinksDto;
import com.atlassian.lighthouse.rest.dto.mapper.AlertDtoMapper;
import com.atlassian.lighthouse.rest.dto.mapper.AlertStatusDtoMapper;
import com.atlassian.lighthouse.rest.dto.mapper.AlertUpdateDtoMapper;
import com.atlassian.lighthouse.rest.i18n.AlertTypeFuzzyNameMatcher;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.service.WebSudoEnforcerService;
import com.atlassian.lighthouse.service.guard.GuardIntegrationMonitor;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindException;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@OpenAPIDefinition(info=@Info(title="Lighthouse Alerting and Monitoring API", description="Endpoints for managing alerts, actors and usage statistics", version="swagger"))
@Path(value="/alerts")
@Produces(value={"application/json"})
@Provider
@LicensedOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 A2\u00020\u0001:\u0001ABc\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0001\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010\"H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010'\u001a\u00020\u001e2\b\b\u0001\u0010(\u001a\u00020\"H\u0007J\u0012\u0010)\u001a\u00020\u001e2\b\b\u0001\u0010*\u001a\u00020+H\u0007J\u001a\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J(\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010\"2\u0006\u00105\u001a\u00020\"2\n\b\u0002\u00106\u001a\u0004\u0018\u000107H\u0002J\u0014\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\b\u0010>\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010?\u001a\b\u0012\u0004\u0012\u00020\"0<2\b\u0010@\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/atlassian/lighthouse/rest/AlertsResource;", "", "alertManager", "Lcom/atlassian/lighthouse/database/dao/AlertManager;", "jsonMapper", "Lcom/atlassian/lighthouse/rest/RestObjectMapper;", "alertDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/AlertDtoMapper;", "alertUpdateDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/AlertUpdateDtoMapper;", "alertStatusDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/AlertStatusDtoMapper;", "alertTypeFuzzyNameMatcher", "Lcom/atlassian/lighthouse/rest/i18n/AlertTypeFuzzyNameMatcher;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "webSudoEnforcerService", "Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "guardIntegrationMonitor", "Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "uriInfo", "Ljakarta/ws/rs/core/UriInfo;", "(Lcom/atlassian/lighthouse/database/dao/AlertManager;Lcom/atlassian/lighthouse/rest/RestObjectMapper;Lcom/atlassian/lighthouse/rest/dto/mapper/AlertDtoMapper;Lcom/atlassian/lighthouse/rest/dto/mapper/AlertUpdateDtoMapper;Lcom/atlassian/lighthouse/rest/dto/mapper/AlertStatusDtoMapper;Lcom/atlassian/lighthouse/rest/i18n/AlertTypeFuzzyNameMatcher;Lcom/atlassian/sal/api/timezone/TimeZoneManager;Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;Ljakarta/servlet/http/HttpServletRequest;Ljakarta/ws/rs/core/UriInfo;)V", "getRequest", "()Ljakarta/servlet/http/HttpServletRequest;", "getUriInfo", "()Ljakarta/ws/rs/core/UriInfo;", "bulkUpdateAlertStatus", "Ljakarta/ws/rs/core/Response;", "requestBody", "Lcom/atlassian/lighthouse/rest/dto/BulkUpdateAlertStatusRequestDto;", "cursorToLinkUrl", "", "cursor", "Lcom/atlassian/lighthouse/rest/AlertsCursor;", "decodeCursor", "encodeCursor", "getAlertByUuid", "uuid", "getAlerts", "params", "Lcom/atlassian/lighthouse/rest/GetAlertsBeanParam;", "getNextCursor", "page", "Lcom/atlassian/lighthouse/database/dao/AlertsPage;", "query", "Lcom/atlassian/lighthouse/database/query/AlertsQuery;", "getPreviousCursor", "toInstant", "Ljava/time/Instant;", "date", "paramName", "timeToCombine", "Ljava/time/LocalTime;", "toSearchComponents", "Lcom/atlassian/lighthouse/database/query/AlertsQueryTextSearchComponents;", "search", "toSetOfAlertStatus", "", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "statuses", "toUserKeys", "userKeys", "Companion", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nAlertsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertsResource.kt\ncom/atlassian/lighthouse/rest/AlertsResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n1#2:339\n1549#3:340\n1620#3,3:341\n1549#3:344\n1620#3,3:345\n1549#3:348\n1620#3,3:349\n1549#3:352\n1620#3,3:353\n*S KotlinDebug\n*F\n+ 1 AlertsResource.kt\ncom/atlassian/lighthouse/rest/AlertsResource\n*L\n161#1:340\n161#1:341,3\n178#1:344\n178#1:345,3\n179#1:348\n179#1:349,3\n318#1:352\n318#1:353,3\n*E\n"})
public class AlertsResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertManager alertManager;
    @NotNull
    private final RestObjectMapper jsonMapper;
    @NotNull
    private final AlertDtoMapper alertDtoMapper;
    @NotNull
    private final AlertUpdateDtoMapper alertUpdateDtoMapper;
    @NotNull
    private final AlertStatusDtoMapper alertStatusDtoMapper;
    @NotNull
    private final AlertTypeFuzzyNameMatcher alertTypeFuzzyNameMatcher;
    @NotNull
    private final TimeZoneManager timeZoneManager;
    @NotNull
    private final WebSudoEnforcerService webSudoEnforcerService;
    @NotNull
    private final GuardIntegrationMonitor guardIntegrationMonitor;
    @NotNull
    private final HttpServletRequest request;
    @NotNull
    private final UriInfo uriInfo;
    @NotNull
    private static final String INVALID_CURSOR = "Invalid cursor";
    @NotNull
    private static final String INVALID_STATUS_FILTER = "Filtering by alert status is not allowed when alerts are being sent to Guard.";
    public static final int STANDARD_AVATAR_SIZE = 48;

    @Inject
    public AlertsResource(@NotNull AlertManager alertManager, @NotNull RestObjectMapper jsonMapper, @NotNull AlertDtoMapper alertDtoMapper, @NotNull AlertUpdateDtoMapper alertUpdateDtoMapper, @NotNull AlertStatusDtoMapper alertStatusDtoMapper, @NotNull AlertTypeFuzzyNameMatcher alertTypeFuzzyNameMatcher, @NotNull TimeZoneManager timeZoneManager, @NotNull WebSudoEnforcerService webSudoEnforcerService, @NotNull GuardIntegrationMonitor guardIntegrationMonitor, @Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo uriInfo) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter((Object)jsonMapper, "jsonMapper");
        Intrinsics.checkNotNullParameter(alertDtoMapper, "alertDtoMapper");
        Intrinsics.checkNotNullParameter(alertUpdateDtoMapper, "alertUpdateDtoMapper");
        Intrinsics.checkNotNullParameter(alertStatusDtoMapper, "alertStatusDtoMapper");
        Intrinsics.checkNotNullParameter(alertTypeFuzzyNameMatcher, "alertTypeFuzzyNameMatcher");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        Intrinsics.checkNotNullParameter(webSudoEnforcerService, "webSudoEnforcerService");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(uriInfo, "uriInfo");
        this.alertManager = alertManager;
        this.jsonMapper = jsonMapper;
        this.alertDtoMapper = alertDtoMapper;
        this.alertUpdateDtoMapper = alertUpdateDtoMapper;
        this.alertStatusDtoMapper = alertStatusDtoMapper;
        this.alertTypeFuzzyNameMatcher = alertTypeFuzzyNameMatcher;
        this.timeZoneManager = timeZoneManager;
        this.webSudoEnforcerService = webSudoEnforcerService;
        this.guardIntegrationMonitor = guardIntegrationMonitor;
        this.request = request;
        this.uriInfo = uriInfo;
    }

    @NotNull
    public final HttpServletRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @GET
    @Operation(tags={"alerts"}, summary="Gets a list of security alerts", description="Returns a list of security alerts.")
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the alerts", responseCode="200"), @ApiResponse(description="Returned if the request is invalid", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user is not authorised to view alerts", responseCode="403")})
    @NotNull
    public final Response getAlerts(@RequestBody @BeanParam @NotNull GetAlertsBeanParam params) {
        String string;
        String string2;
        AlertsPage alertsPage;
        AlertsCursor alertsCursor;
        Intrinsics.checkNotNullParameter(params, "params");
        this.webSudoEnforcerService.enforceWebSudoIfApplicable(this.request);
        String startDate = params.component1();
        String endDate = params.component2();
        String search = params.component3();
        String userKeys = params.component4();
        int size = params.component5();
        String encodedCursor = params.component6();
        String statuses = params.component7();
        if (statuses != null && this.guardIntegrationMonitor.canSendAlerts()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)INVALID_STATUS_FILTER).build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        try {
            alertsCursor = this.decodeCursor(encodedCursor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)INVALID_CURSOR).build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        AlertsCursor alertsCursor2 = alertsCursor;
        Object object = alertsCursor2;
        if (object == null || (object = ((AlertsCursor)object).toQuery()) == null) {
            object = new AlertsQuery(null, AlertsResource.toInstant$default(this, startDate, "startDate", null, 4, null), this.toInstant(endDate, "endDate", LocalTime.MAX), null, this.toUserKeys(userKeys), this.toSearchComponents(search), PageRequest.Companion.first(size), this.toSetOfAlertStatus(statuses), 9, null);
        }
        Object alertsQuery = object;
        try {
            alertsPage = this.alertManager.getAlerts((AlertsQuery)alertsQuery);
        }
        catch (IllegalArgumentException e) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        AlertsPage alertsPage2 = alertsPage;
        AlertsCursor alertsCursor3 = this.getNextCursor(alertsPage2, (AlertsQuery)alertsQuery);
        if (alertsCursor3 != null) {
            AlertsCursor p0 = alertsCursor3;
            boolean bl = false;
            string2 = this.cursorToLinkUrl(p0);
        } else {
            string2 = null;
        }
        String nextLink = string2;
        AlertsCursor alertsCursor4 = this.getPreviousCursor(alertsPage2, (AlertsQuery)alertsQuery);
        if (alertsCursor4 != null) {
            AlertsCursor p0 = alertsCursor4;
            boolean bl = false;
            string = this.cursorToLinkUrl(p0);
        } else {
            string = null;
        }
        String previousLink = string;
        List<AlertDto> alertDtos = this.alertDtoMapper.fromAlertEntities(alertsPage2.getAlerts(), 48);
        Response response = Response.ok((Object)this.jsonMapper.writeValueAsString(new GetAlertsResponseDto(alertDtos.size(), alertDtos, new LinksDto(nextLink, previousLink)))).build();
        Intrinsics.checkNotNullExpressionValue(response, "build(...)");
        return response;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Set<String> toUserKeys(String userKeys) {
        Set<String> set;
        if (userKeys != null) {
            String[] stringArray = new String[]{","};
            List list = StringsKt.split$default((CharSequence)userKeys, stringArray, false, 0, 6, null);
            if (list != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Set set2 = (Set)((Object)list);
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
                if (set2 != null) {
                    set = set2;
                    return set;
                }
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    private final AlertsQueryTextSearchComponents toSearchComponents(String search) {
        if (search == null) {
            return null;
        }
        Object object = Regex.find$default(new Regex("\\d+$"), ((Object)StringsKt.trim((CharSequence)search)).toString(), 0, 2, null);
        Long extractedNumericSearchComponent = object != null && (object = object.getValue()) != null ? StringsKt.toLongOrNull((String)object) : null;
        Set<AlertType> alertTypes = this.alertTypeFuzzyNameMatcher.findAlertsContaining(search);
        return new AlertsQueryTextSearchComponents(extractedNumericSearchComponent, alertTypes);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Set<AlertStatus> toSetOfAlertStatus(String statuses) {
        try {
            Set<AlertStatus> set;
            if (statuses != null) {
                String[] stringArray = new String[]{","};
                List list = StringsKt.split$default((CharSequence)statuses, stringArray, false, 0, 6, null);
                if (list != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Collection collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Iterable iterable = list;
                    boolean $i$f$map22 = false;
                    AlertStatusDtoMapper alertStatusDtoMapper = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void p0;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
                    }
                    Iterable $i$f$map22 = (List)destination$iv$iv;
                    alertStatusDtoMapper = this.alertStatusDtoMapper;
                    boolean $i$f$map = false;
                    void $i$f$mapTo22 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(alertStatusDtoMapper.fromStringToAlertStatus((String)p0));
                    }
                    Set set2 = CollectionsKt.toSet((List)destination$iv$iv2);
                    if (set2 != null) {
                        set = set2;
                        return set;
                    }
                }
            }
            set = SetsKt.emptySet();
            return set;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private final Instant toInstant(String date, String paramName, LocalTime timeToCombine) {
        Instant instant;
        try {
            Instant instant2;
            String string = date;
            if (string != null) {
                String it = string;
                boolean bl = false;
                instant2 = LocalDate.parse(date).atTime(timeToCombine).atZone(this.timeZoneManager.getUserTimeZone().toZoneId()).toInstant();
            } else {
                instant2 = null;
            }
            instant = instant2;
        }
        catch (DateTimeParseException e) {
            throw new BadRequestException("Invalid " + paramName + " format. Required format is yyyy-MM-dd");
        }
        return instant;
    }

    static /* synthetic */ Instant toInstant$default(AlertsResource alertsResource, String string, String string2, LocalTime localTime, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toInstant");
        }
        if ((n & 4) != 0) {
            localTime = LocalTime.MIN;
        }
        return alertsResource.toInstant(string, string2, localTime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AlertsCursor getNextCursor(AlertsPage page, AlertsQuery query) {
        Cursor cursor = page.getFollowing();
        if (cursor == null) return null;
        Cursor it = cursor;
        boolean bl = false;
        PageRequest pageRequest = query.getPageRequest();
        PageRequest pageRequest2 = PageRequest.Companion.next(it, pageRequest != null ? pageRequest.getSize() : 10);
        if (pageRequest2 == null) return null;
        PageRequest pageRequest3 = pageRequest2;
        boolean bl2 = false;
        AlertsCursor alertsCursor = AlertsCursor.Companion.fromQueryAndPageRequest(query, pageRequest3);
        return alertsCursor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AlertsCursor getPreviousCursor(AlertsPage page, AlertsQuery query) {
        Cursor cursor = page.getPreceding();
        if (cursor == null) return null;
        Cursor it = cursor;
        boolean bl = false;
        PageRequest pageRequest = query.getPageRequest();
        PageRequest pageRequest2 = PageRequest.Companion.previous(it, pageRequest != null ? pageRequest.getSize() : 10);
        if (pageRequest2 == null) return null;
        PageRequest pageRequest3 = pageRequest2;
        boolean bl2 = false;
        AlertsCursor alertsCursor = AlertsCursor.Companion.fromQueryAndPageRequest(query, pageRequest3);
        return alertsCursor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String encodeCursor(AlertsCursor cursor) {
        if (cursor == null) return null;
        AlertsCursor alertsCursor = cursor;
        RestObjectMapper restObjectMapper = this.jsonMapper;
        AlertsCursor p0 = alertsCursor;
        boolean bl = false;
        String string = restObjectMapper.writeValueAsString(p0);
        if (string == null) return null;
        String it = string;
        boolean bl2 = false;
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        byte[] byArray = it.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        String string2 = encoder.encodeToString(byArray);
        return string2;
    }

    private final AlertsCursor decodeCursor(String cursor) {
        AlertsCursor alertsCursor;
        try {
            AlertsCursor alertsCursor2;
            if (cursor != null) {
                String it = cursor;
                boolean bl = false;
                byte[] byArray = Base64.getUrlDecoder().decode(it);
                Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
                byte[] byArray2 = byArray;
                it = new String(byArray2, Charsets.UTF_8);
                boolean bl2 = false;
                alertsCursor2 = (AlertsCursor)this.jsonMapper.readValue(it, AlertsCursor.class);
            } else {
                alertsCursor2 = null;
            }
            alertsCursor = alertsCursor2;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(INVALID_CURSOR);
        }
        catch (DatabindException e) {
            throw new IllegalArgumentException(INVALID_CURSOR);
        }
        return alertsCursor;
    }

    private final String cursorToLinkUrl(AlertsCursor cursor) {
        Object[] objectArray = new Object[]{this.encodeCursor(cursor)};
        String string = this.uriInfo.getBaseUriBuilder().path(AlertsResource.class).queryParam("cursor", objectArray).build(new Object[0]).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @GET
    @Path(value="/{uuid}")
    @Operation(tags={"alerts"}, summary="Get a security alert", description="Retrieves a security alert by its UUID.")
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the alert", responseCode="200"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user is not authorised to view the alert", responseCode="403"), @ApiResponse(description="Returned if the alert does not exist", responseCode="404")})
    @NotNull
    public final Response getAlertByUuid(@PathParam(value="uuid") @NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        this.webSudoEnforcerService.enforceWebSudoIfApplicable(this.request);
        AlertEntity alertEntity = this.alertManager.getAlertByUuid(uuid);
        if (alertEntity == null) {
            Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        AlertEntity alertEntity2 = alertEntity;
        AlertDto alert = this.alertDtoMapper.fromAlertEntity(alertEntity2, 48);
        Response response = Response.ok((Object)this.jsonMapper.writeValueAsString(alert)).build();
        Intrinsics.checkNotNullExpressionValue(response, "build(...)");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="/bulk-update-alert-status")
    @Operation(tags={"alerts"}, summary="Bulk update alert status", description="Bulk update the status of multiple alerts.")
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the alerts", responseCode="200"), @ApiResponse(description="Returned if the request is invalid", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user is not authorised to view alerts", responseCode="403")})
    @RequestBody(description="The UUIDs of the alerts to update and the new status.", required=true)
    @NotNull
    public final Response bulkUpdateAlertStatus(@RequestBody @NotNull BulkUpdateAlertStatusRequestDto requestBody) {
        Intrinsics.checkNotNullParameter(requestBody, "requestBody");
        this.webSudoEnforcerService.enforceWebSudoIfApplicable(this.request);
        if (this.guardIntegrationMonitor.canSendAlerts()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Updating alert statuses is not allowed when alerts are being sent to Guard.").build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AlertStatus status = this.alertStatusDtoMapper.fromStringToAlertStatus(requestBody.getStatus());
            List<AlertEntity> updatedAlerts = this.alertManager.bulkUpdateAlertStatusByUuid(requestBody.getAlertUuids(), status);
            Iterable iterable = updatedAlerts;
            RestObjectMapper restObjectMapper = this.jsonMapper;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AlertEntity alertEntity = (AlertEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.alertUpdateDtoMapper.fromAlertEntityToAlertUpdateDto((AlertEntity)it));
            }
            List list = (List)destination$iv$iv;
            Response response = Response.ok((Object)restObjectMapper.writeValueAsString(new BulkUpdateAlertStatusResponseDto(list))).build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        catch (IllegalArgumentException e) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/lighthouse/rest/AlertsResource$Companion;", "", "()V", "INVALID_CURSOR", "", "INVALID_STATUS_FILTER", "STANDARD_AVATAR_SIZE", "", "atlassian-lighthouse-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

