/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.lighthouse.rest.RestObjectMapper;
import com.atlassian.lighthouse.rest.dto.mapper.ActorDtoMapper;
import com.atlassian.lighthouse.security.service.WebSudoEnforcerService;
import com.atlassian.lighthouse.service.user.Constants;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.sal.api.message.I18nResolver;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/userSearch")
@Produces(value={"application/json"})
@Provider
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/lighthouse/rest/UserSearchResource;", "", "actorDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;", "crowdService", "Lcom/atlassian/crowd/embedded/api/CrowdService;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "jsonMapper", "Lcom/atlassian/lighthouse/rest/RestObjectMapper;", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "webSudoEnforcerService", "Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "(Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;Lcom/atlassian/crowd/embedded/api/CrowdService;Lcom/atlassian/sal/api/message/I18nResolver;Lcom/atlassian/lighthouse/rest/RestObjectMapper;Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;Ljakarta/servlet/http/HttpServletRequest;)V", "constructUsersQuery", "Lcom/atlassian/crowd/search/query/entity/EntityQuery;", "", "searchTerm", "resultsNeeded", "", "findMetaUserDetails", "", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "searchParam", "findUsers", "Ljakarta/ws/rs/core/Response;", "Companion", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nUserSearchResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserSearchResource.kt\ncom/atlassian/lighthouse/rest/UserSearchResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1549#2:113\n1620#2,3:114\n766#2:117\n857#2,2:118\n1549#2:120\n1620#2,3:121\n*S KotlinDebug\n*F\n+ 1 UserSearchResource.kt\ncom/atlassian/lighthouse/rest/UserSearchResource\n*L\n71#1:113\n71#1:114,3\n72#1:117\n72#1:118,2\n74#1:120\n74#1:121,3\n*E\n"})
public class UserSearchResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActorDtoMapper actorDtoMapper;
    @NotNull
    private final CrowdService crowdService;
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final RestObjectMapper jsonMapper;
    @NotNull
    private final UserDetailsFinder userDetailsFinder;
    @NotNull
    private final WebSudoEnforcerService webSudoEnforcerService;
    @NotNull
    private final HttpServletRequest request;
    @NotNull
    private static final String SYSTEM_USER_DISPLAY_I18N_KEY = "lighthouse.meta-users.system.display-name";
    @NotNull
    private static final String ANONYMOUS_USER_DISPLAY_I18N_KEY = "lighthouse.meta-users.anonymous.display-name";
    private static final int MAX_RESULTS = 10;

    @Inject
    public UserSearchResource(@NotNull ActorDtoMapper actorDtoMapper, @NotNull CrowdService crowdService, @NotNull I18nResolver i18nResolver, @NotNull RestObjectMapper jsonMapper, @NotNull UserDetailsFinder userDetailsFinder, @NotNull WebSudoEnforcerService webSudoEnforcerService, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter(actorDtoMapper, "actorDtoMapper");
        Intrinsics.checkNotNullParameter(crowdService, "crowdService");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter((Object)jsonMapper, "jsonMapper");
        Intrinsics.checkNotNullParameter(userDetailsFinder, "userDetailsFinder");
        Intrinsics.checkNotNullParameter(webSudoEnforcerService, "webSudoEnforcerService");
        Intrinsics.checkNotNullParameter(request, "request");
        this.actorDtoMapper = actorDtoMapper;
        this.crowdService = crowdService;
        this.i18nResolver = i18nResolver;
        this.jsonMapper = jsonMapper;
        this.userDetailsFinder = userDetailsFinder;
        this.webSudoEnforcerService = webSudoEnforcerService;
        this.request = request;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Operation(tags={"ui"}, summary="Gets a list of user keys matching search term", description="Returns a list of user keys matching search term.")
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the user keys matching search term", responseCode="200"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the authenticated user does not have permission to access the endpoint", responseCode="403")})
    @NotNull
    public final Response findUsers(@QueryParam(value="filter") @Nullable String searchParam) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        UserDetails it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        this.webSudoEnforcerService.enforceWebSudoIfApplicable(this.request);
        String string = searchParam;
        if (string == null) {
            string = "";
        }
        String searchTerm = string;
        List<UserDetails> foundMetaUserDetails = this.findMetaUserDetails(searchTerm);
        Iterable iterable = this.crowdService.search((Query)this.constructUsersQuery(searchTerm, 10 - foundMetaUserDetails.size()));
        Intrinsics.checkNotNullExpressionValue(iterable, "search(...)");
        Iterable iterable2 = iterable;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection.add(this.userDetailsFinder.fromUsername((String)((Object)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UserDetails)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getUserKey(), Constants.INSTANCE.getUNKNOWN_USER_KEY()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List foundUsers = (List)destination$iv$iv;
        Iterable $this$map$iv2 = CollectionsKt.plus((Collection)foundMetaUserDetails, (Iterable)foundUsers);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            UserDetails bl = (UserDetails)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(this.actorDtoMapper.fromUserDetails((UserDetails)it2, 48));
        }
        List foundActors = (List)destination$iv$iv2;
        Response response = Response.ok((Object)this.jsonMapper.writeValueAsString(foundActors)).build();
        Intrinsics.checkNotNullExpressionValue(response, "build(...)");
        return response;
    }

    private final List<UserDetails> findMetaUserDetails(String searchParam) {
        String systemUserDisplayName = this.i18nResolver.getText(SYSTEM_USER_DISPLAY_I18N_KEY);
        String anonymousUserDisplayName = this.i18nResolver.getText(ANONYMOUS_USER_DISPLAY_I18N_KEY);
        List foundUserDetails = new ArrayList();
        Intrinsics.checkNotNull(systemUserDisplayName);
        if (StringsKt.contains((CharSequence)systemUserDisplayName, searchParam, true)) {
            foundUserDetails.add(new UserDetails(null, null, Constants.INSTANCE.getSYSTEM_USER_KEY(), "", false, false));
        }
        Intrinsics.checkNotNull(anonymousUserDisplayName);
        if (StringsKt.contains((CharSequence)anonymousUserDisplayName, searchParam, true)) {
            foundUserDetails.add(new UserDetails(null, null, Constants.INSTANCE.getANONYMOUS_USER_KEY(), "", false, false));
        }
        return foundUserDetails;
    }

    private final EntityQuery<String> constructUsersQuery(String searchTerm, int resultsNeeded) {
        List restrictions = new ArrayList();
        String trimmedSearch = ((Object)StringsKt.trim((CharSequence)searchTerm)).toString();
        restrictions.add(new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)trimmedSearch));
        restrictions.add(new TermRestriction(UserTermKeys.USERNAME, MatchMode.EXACTLY_MATCHES, (Object)trimmedSearch));
        EntityQuery entityQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)((SearchRestriction)Combine.anyOf((Collection)restrictions)), (int)0, (int)resultsNeeded);
        Intrinsics.checkNotNullExpressionValue(entityQuery, "queryFor(...)");
        return entityQuery;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/lighthouse/rest/UserSearchResource$Companion;", "", "()V", "ANONYMOUS_USER_DISPLAY_I18N_KEY", "", "MAX_RESULTS", "", "SYSTEM_USER_DISPLAY_I18N_KEY", "atlassian-lighthouse-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

