/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest;

import com.atlassian.lighthouse.rest.RestObjectMapper;
import com.atlassian.lighthouse.rest.dto.UserUsageStatisticsDto;
import com.atlassian.lighthouse.rest.dto.mapper.UserUsageStatisticsDtoMapper;
import com.atlassian.lighthouse.security.service.WebSudoEnforcerService;
import com.atlassian.lighthouse.usage.service.UserUsageStatisticsService;
import com.atlassian.sal.api.user.UserKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="/usage")
@Produces(value={"application/json"})
@Provider
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/rest/UserUsageStatisticsResource;", "", "jsonMapper", "Lcom/atlassian/lighthouse/rest/RestObjectMapper;", "userUsageStatisticsService", "Lcom/atlassian/lighthouse/usage/service/UserUsageStatisticsService;", "userUsageStatisticsDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/UserUsageStatisticsDtoMapper;", "webSudoEnforcerService", "Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "(Lcom/atlassian/lighthouse/rest/RestObjectMapper;Lcom/atlassian/lighthouse/usage/service/UserUsageStatisticsService;Lcom/atlassian/lighthouse/rest/dto/mapper/UserUsageStatisticsDtoMapper;Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;Ljakarta/servlet/http/HttpServletRequest;)V", "getRequest", "()Ljakarta/servlet/http/HttpServletRequest;", "getUserUsageStatistics", "Ljakarta/ws/rs/core/Response;", "userKey", "", "atlassian-lighthouse-rest"})
public class UserUsageStatisticsResource {
    @NotNull
    private final RestObjectMapper jsonMapper;
    @NotNull
    private final UserUsageStatisticsService userUsageStatisticsService;
    @NotNull
    private final UserUsageStatisticsDtoMapper userUsageStatisticsDtoMapper;
    @NotNull
    private final WebSudoEnforcerService webSudoEnforcerService;
    @NotNull
    private final HttpServletRequest request;

    @Inject
    public UserUsageStatisticsResource(@NotNull RestObjectMapper jsonMapper, @NotNull UserUsageStatisticsService userUsageStatisticsService, @NotNull UserUsageStatisticsDtoMapper userUsageStatisticsDtoMapper, @NotNull WebSudoEnforcerService webSudoEnforcerService, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, "jsonMapper");
        Intrinsics.checkNotNullParameter(userUsageStatisticsService, "userUsageStatisticsService");
        Intrinsics.checkNotNullParameter(userUsageStatisticsDtoMapper, "userUsageStatisticsDtoMapper");
        Intrinsics.checkNotNullParameter(webSudoEnforcerService, "webSudoEnforcerService");
        Intrinsics.checkNotNullParameter(request, "request");
        this.jsonMapper = jsonMapper;
        this.userUsageStatisticsService = userUsageStatisticsService;
        this.userUsageStatisticsDtoMapper = userUsageStatisticsDtoMapper;
        this.webSudoEnforcerService = webSudoEnforcerService;
        this.request = request;
    }

    @NotNull
    public final HttpServletRequest getRequest() {
        return this.request;
    }

    @GET
    @Path(value="{userKey}")
    @Operation(tags={"alerts"}, summary="Gets usage and alerts data from the given user over the last 12 months.", description="Retrieves the user's audit and alerting data collated by month.")
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the user's usag data", responseCode="200"), @ApiResponse(description="Returned if the user is not authenticated", responseCode="401"), @ApiResponse(description="Returned if the user is not authorised to see usage data", responseCode="403")})
    @NotNull
    public final Response getUserUsageStatistics(@PathParam(value="userKey") @NotNull String userKey) {
        Intrinsics.checkNotNullParameter(userKey, "userKey");
        this.webSudoEnforcerService.enforceWebSudoIfApplicable(this.request);
        if (((CharSequence)userKey).length() == 0) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User key must not be empty").build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        if (userKey.length() > 1000) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User key must not be longer than 1000 characters").build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        UserUsageStatisticsDto usage = this.userUsageStatisticsDtoMapper.fromCollatedUserSystemUsage(this.userUsageStatisticsService.getSystemUsage(new UserKey(userKey)));
        Response response = Response.ok((Object)this.jsonMapper.writeValueAsString(usage)).build();
        Intrinsics.checkNotNullExpressionValue(response, "build(...)");
        return response;
    }
}

