/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.actor;

import com.atlassian.lighthouse.rest.actor.SalActorUrlsProvider;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/lighthouse/rest/actor/JiraActorUrlsProvider;", "Lcom/atlassian/lighthouse/rest/actor/SalActorUrlsProvider;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "salUserManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/sal/api/user/UserManager;)V", "getEditUserUrl", "Ljava/net/URI;", "userDetails", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "atlassian-lighthouse-rest"})
public final class JiraActorUrlsProvider
extends SalActorUrlsProvider {
    public JiraActorUrlsProvider(@NotNull ApplicationProperties applicationProperties, @NotNull UserManager salUserManager) {
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        Intrinsics.checkNotNullParameter(salUserManager, "salUserManager");
        super(applicationProperties, salUserManager);
    }

    @Override
    @Nullable
    public URI getEditUserUrl(@NotNull UserDetails userDetails) {
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        String urlEncodedUsername = URLEncoder.encode(userDetails.getUsername(), StandardCharsets.UTF_8);
        return URI.create("secure/admin/user/ViewUser.jspa?name=" + urlEncodedUsername);
    }
}

