/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.actor;

import com.atlassian.lighthouse.rest.actor.ActorUrlsProvider;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/lighthouse/rest/actor/SalActorUrlsProvider;", "Lcom/atlassian/lighthouse/rest/actor/ActorUrlsProvider;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "salUserManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/sal/api/user/UserManager;)V", "getApplicationProperties", "()Lcom/atlassian/sal/api/ApplicationProperties;", "getSalUserManager", "()Lcom/atlassian/sal/api/user/UserManager;", "addBaseUrlTo", "", "relativeUrl", "Ljava/net/URI;", "getAvatarUrl", "userDetails", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "avatarSize", "", "getEditUserUrl", "getManageActorUrl", "getUserProfileUrl", "atlassian-lighthouse-rest"})
public abstract class SalActorUrlsProvider
implements ActorUrlsProvider {
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final UserManager salUserManager;

    public SalActorUrlsProvider(@NotNull ApplicationProperties applicationProperties, @NotNull UserManager salUserManager) {
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        Intrinsics.checkNotNullParameter(salUserManager, "salUserManager");
        this.applicationProperties = applicationProperties;
        this.salUserManager = salUserManager;
    }

    @NotNull
    public final ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    @NotNull
    public final UserManager getSalUserManager() {
        return this.salUserManager;
    }

    @Override
    @Nullable
    public String getAvatarUrl(@NotNull UserDetails userDetails, int avatarSize) {
        UserProfile userProfile;
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        UserProfile userProfile2 = userProfile = this.salUserManager.getUserProfile(new UserKey(userDetails.getUserKey()));
        return this.addBaseUrlTo(userProfile2 != null ? userProfile2.getProfilePictureUri(avatarSize, avatarSize) : null);
    }

    @Override
    @Nullable
    public final String getManageActorUrl(@NotNull UserDetails userDetails) {
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        URI appropriateActorUrl = this.salUserManager.isSystemAdmin(this.salUserManager.getRemoteUserKey()) ? this.getEditUserUrl(userDetails) : this.getUserProfileUrl(userDetails);
        return this.addBaseUrlTo(appropriateActorUrl);
    }

    @Nullable
    public abstract URI getEditUserUrl(@NotNull UserDetails var1);

    @Nullable
    public final URI getUserProfileUrl(@NotNull UserDetails userDetails) {
        UserProfile userProfile;
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        UserProfile userProfile2 = userProfile = this.salUserManager.getUserProfile(new UserKey(userDetails.getUserKey()));
        return userProfile2 != null ? userProfile2.getProfilePageUri() : null;
    }

    private final String addBaseUrlTo(URI relativeUrl) {
        Object object;
        if (relativeUrl == null) {
            return null;
        }
        if (relativeUrl.isAbsolute()) {
            object = relativeUrl.toString();
        } else {
            String it = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            String baseUrl = StringsKt.endsWith$default(it, "/", false, 2, null) ? StringsKt.dropLast(it, 1) : it;
            it = relativeUrl.toString();
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            object = StringsKt.startsWith$default(it, "/", false, 2, null) ? baseUrl + it : baseUrl + "/" + it;
        }
        return object;
    }
}

