/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.dto;

import com.atlassian.lighthouse.rest.dto.AdminTypeDto;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="The actor responsible for triggering an alert")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BQ\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u0012\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JU\u0010\u001e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00032\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/atlassian/lighthouse/rest/dto/ActorDto;", "", "displayName", "", "avatarUrl", "userKey", "adminType", "Lcom/atlassian/lighthouse/rest/dto/AdminTypeDto;", "metaUser", "", "username", "manageUserUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/lighthouse/rest/dto/AdminTypeDto;ZLjava/lang/String;Ljava/lang/String;)V", "getAdminType", "()Lcom/atlassian/lighthouse/rest/dto/AdminTypeDto;", "getAvatarUrl", "()Ljava/lang/String;", "getDisplayName", "getManageUserUrl", "getMetaUser", "()Z", "getUserKey", "getUsername", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "atlassian-lighthouse-rest"})
public final class ActorDto {
    @NotNull
    private final String displayName;
    @Nullable
    private final String avatarUrl;
    @NotNull
    private final String userKey;
    @NotNull
    private final AdminTypeDto adminType;
    private final boolean metaUser;
    @Nullable
    private final String username;
    @Nullable
    private final String manageUserUrl;

    public ActorDto(@Schema(description="The display name of the actor ie John Smith") @JsonProperty(value="displayName") @NotNull String displayName, @Schema(description="The avatar URL of the actor, can be used to display the avatar, metaUsers will not have an avatar") @JsonProperty(value="avatarUrl") @Nullable String avatarUrl, @Schema(description="The user key of the actor, can be used to look up the user in the user directory") @JsonProperty(value="userKey") @NotNull String userKey, @Schema(description="The admin type of the actor, ie system or regular admin") @JsonProperty(value="adminType") @NotNull AdminTypeDto adminType, @Schema(description="Whether the actor is a meta user, ie Anonymous, System etc") @JsonProperty(value="metaUser") boolean metaUser, @Schema(description="The username of the actor") @JsonProperty(value="username") @Nullable String username, @Schema(description="A link to the user management page for the actor/user") @JsonProperty(value="manageUserUrl") @Nullable String manageUserUrl) {
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(userKey, "userKey");
        Intrinsics.checkNotNullParameter((Object)adminType, "adminType");
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
        this.userKey = userKey;
        this.adminType = adminType;
        this.metaUser = metaUser;
        this.username = username;
        this.manageUserUrl = manageUserUrl;
    }

    public /* synthetic */ ActorDto(String string, String string2, String string3, AdminTypeDto adminTypeDto, boolean bl, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            string5 = null;
        }
        this(string, string2, string3, adminTypeDto, bl, string4, string5);
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public final String getAvatarUrl() {
        return this.avatarUrl;
    }

    @NotNull
    public final String getUserKey() {
        return this.userKey;
    }

    @NotNull
    public final AdminTypeDto getAdminType() {
        return this.adminType;
    }

    public final boolean getMetaUser() {
        return this.metaUser;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    @Nullable
    public final String getManageUserUrl() {
        return this.manageUserUrl;
    }

    @NotNull
    public final String component1() {
        return this.displayName;
    }

    @Nullable
    public final String component2() {
        return this.avatarUrl;
    }

    @NotNull
    public final String component3() {
        return this.userKey;
    }

    @NotNull
    public final AdminTypeDto component4() {
        return this.adminType;
    }

    public final boolean component5() {
        return this.metaUser;
    }

    @Nullable
    public final String component6() {
        return this.username;
    }

    @Nullable
    public final String component7() {
        return this.manageUserUrl;
    }

    @NotNull
    public final ActorDto copy(@Schema(description="The display name of the actor ie John Smith") @JsonProperty(value="displayName") @NotNull String displayName, @Schema(description="The avatar URL of the actor, can be used to display the avatar, metaUsers will not have an avatar") @JsonProperty(value="avatarUrl") @Nullable String avatarUrl, @Schema(description="The user key of the actor, can be used to look up the user in the user directory") @JsonProperty(value="userKey") @NotNull String userKey, @Schema(description="The admin type of the actor, ie system or regular admin") @JsonProperty(value="adminType") @NotNull AdminTypeDto adminType, @Schema(description="Whether the actor is a meta user, ie Anonymous, System etc") @JsonProperty(value="metaUser") boolean metaUser, @Schema(description="The username of the actor") @JsonProperty(value="username") @Nullable String username, @Schema(description="A link to the user management page for the actor/user") @JsonProperty(value="manageUserUrl") @Nullable String manageUserUrl) {
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(userKey, "userKey");
        Intrinsics.checkNotNullParameter((Object)adminType, "adminType");
        return new ActorDto(displayName, avatarUrl, userKey, adminType, metaUser, username, manageUserUrl);
    }

    public static /* synthetic */ ActorDto copy$default(ActorDto actorDto, String string, String string2, String string3, AdminTypeDto adminTypeDto, boolean bl, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = actorDto.displayName;
        }
        if ((n & 2) != 0) {
            string2 = actorDto.avatarUrl;
        }
        if ((n & 4) != 0) {
            string3 = actorDto.userKey;
        }
        if ((n & 8) != 0) {
            adminTypeDto = actorDto.adminType;
        }
        if ((n & 0x10) != 0) {
            bl = actorDto.metaUser;
        }
        if ((n & 0x20) != 0) {
            string4 = actorDto.username;
        }
        if ((n & 0x40) != 0) {
            string5 = actorDto.manageUserUrl;
        }
        return actorDto.copy(string, string2, string3, adminTypeDto, bl, string4, string5);
    }

    @NotNull
    public String toString() {
        return "ActorDto(displayName=" + this.displayName + ", avatarUrl=" + this.avatarUrl + ", userKey=" + this.userKey + ", adminType=" + this.adminType + ", metaUser=" + this.metaUser + ", username=" + this.username + ", manageUserUrl=" + this.manageUserUrl + ")";
    }

    public int hashCode() {
        int result = this.displayName.hashCode();
        result = result * 31 + (this.avatarUrl == null ? 0 : this.avatarUrl.hashCode());
        result = result * 31 + this.userKey.hashCode();
        result = result * 31 + this.adminType.hashCode();
        result = result * 31 + Boolean.hashCode(this.metaUser);
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        result = result * 31 + (this.manageUserUrl == null ? 0 : this.manageUserUrl.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActorDto)) {
            return false;
        }
        ActorDto actorDto = (ActorDto)other;
        if (!Intrinsics.areEqual(this.displayName, actorDto.displayName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.avatarUrl, actorDto.avatarUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userKey, actorDto.userKey)) {
            return false;
        }
        if (this.adminType != actorDto.adminType) {
            return false;
        }
        if (this.metaUser != actorDto.metaUser) {
            return false;
        }
        if (!Intrinsics.areEqual(this.username, actorDto.username)) {
            return false;
        }
        return Intrinsics.areEqual(this.manageUserUrl, actorDto.manageUserUrl);
    }
}

