/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.dto.mapper;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.i18n.AlertTypeI18nMapper;
import com.atlassian.lighthouse.rest.dto.ActorDto;
import com.atlassian.lighthouse.rest.dto.AlertDto;
import com.atlassian.lighthouse.rest.dto.mapper.ActorDtoMapper;
import com.atlassian.lighthouse.rest.i18n.AlertSummary;
import com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider;
import com.atlassian.lighthouse.security.detector.EmailStatus;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ.\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J&\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00112\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/lighthouse/rest/dto/mapper/AlertDtoMapper;", "", "actorDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;", "alertSummaryProvider", "Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryProvider;", "alertTypeI18nMapper", "Lcom/atlassian/lighthouse/i18n/AlertTypeI18nMapper;", "", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "(Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryProvider;Lcom/atlassian/lighthouse/i18n/AlertTypeI18nMapper;Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;)V", "createActorDtoMapFromAlertEntities", "", "Lcom/atlassian/lighthouse/rest/dto/ActorDto;", "alertEntities", "", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "avatarSize", "", "fromAlertEntities", "Lcom/atlassian/lighthouse/rest/dto/AlertDto;", "fromAlertEntity", "alertEntity", "actorMap", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nAlertDtoMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertDtoMapper.kt\ncom/atlassian/lighthouse/rest/dto/mapper/AlertDtoMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n1360#2:81\n1446#2,2:82\n1549#2:84\n1620#2,3:85\n1448#2,3:88\n1271#2,2:91\n1285#2,2:93\n1288#2:96\n1549#2:97\n1620#2,3:98\n1#3:95\n*S KotlinDebug\n*F\n+ 1 AlertDtoMapper.kt\ncom/atlassian/lighthouse/rest/dto/mapper/AlertDtoMapper\n*L\n38#1:77\n38#1:78,3\n49#1:81\n49#1:82,2\n50#1:84\n50#1:85,3\n49#1:88,3\n58#1:91,2\n58#1:93,2\n58#1:96\n65#1:97\n65#1:98,3\n*E\n"})
public final class AlertDtoMapper {
    @NotNull
    private final ActorDtoMapper actorDtoMapper;
    @NotNull
    private final AlertSummaryProvider alertSummaryProvider;
    @NotNull
    private final AlertTypeI18nMapper<String> alertTypeI18nMapper;
    @NotNull
    private final UserDetailsFinder userDetailsFinder;

    public AlertDtoMapper(@NotNull ActorDtoMapper actorDtoMapper, @NotNull AlertSummaryProvider alertSummaryProvider, @NotNull AlertTypeI18nMapper<String> alertTypeI18nMapper, @NotNull UserDetailsFinder userDetailsFinder) {
        Intrinsics.checkNotNullParameter(actorDtoMapper, "actorDtoMapper");
        Intrinsics.checkNotNullParameter(alertSummaryProvider, "alertSummaryProvider");
        Intrinsics.checkNotNullParameter(alertTypeI18nMapper, "alertTypeI18nMapper");
        Intrinsics.checkNotNullParameter(userDetailsFinder, "userDetailsFinder");
        this.actorDtoMapper = actorDtoMapper;
        this.alertSummaryProvider = alertSummaryProvider;
        this.alertTypeI18nMapper = alertTypeI18nMapper;
        this.userDetailsFinder = userDetailsFinder;
    }

    @NotNull
    public final AlertDto fromAlertEntity(@NotNull AlertEntity alertEntity, int avatarSize) {
        Intrinsics.checkNotNullParameter(alertEntity, "alertEntity");
        Map<String, ActorDto> actorsMap = this.createActorDtoMapFromAlertEntities(CollectionsKt.listOf(alertEntity), avatarSize);
        return this.fromAlertEntity(alertEntity, actorsMap);
    }

    public static /* synthetic */ AlertDto fromAlertEntity$default(AlertDtoMapper alertDtoMapper, AlertEntity alertEntity, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 48;
        }
        return alertDtoMapper.fromAlertEntity(alertEntity, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AlertDto> fromAlertEntities(@NotNull List<AlertEntity> alertEntities, int avatarSize) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(alertEntities, "alertEntities");
        Map<String, ActorDto> actorsMap = this.createActorDtoMapFromAlertEntities(alertEntities, avatarSize);
        Iterable $this$map$iv = alertEntities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void alertEntity;
            AlertEntity alertEntity2 = (AlertEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fromAlertEntity((AlertEntity)alertEntity, actorsMap));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List fromAlertEntities$default(AlertDtoMapper alertDtoMapper, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 48;
        }
        return alertDtoMapper.fromAlertEntities(list, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ActorDto> createActorDtoMapFromAlertEntities(List<AlertEntity> alertEntities, int avatarSize) {
        List<Object> list;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        List<Object> $this$flatMap$iv;
        Iterable iterable = alertEntities;
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            AlertEntity alertEntity = (AlertEntity)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = alertEntity.getThreatEvents();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void threatEvent;
                ThreatEventEntity threatEventEntity = (ThreatEventEntity)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(threatEvent.getTriggeringUserKey());
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = CollectionsKt.distinct((List)destination$iv$iv);
        if ($this$flatMap$iv.isEmpty()) {
            boolean bl = false;
            list = CollectionsKt.listOf(null);
        } else {
            list = $this$flatMap$iv;
        }
        List userKeys = list;
        Iterable $this$associateWith$iv = userKeys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            list$iv$iv = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            UserDetails it2 = this.userDetailsFinder.fromUserKey((String)it);
            boolean bl3 = false;
            ActorDto actorDto = this.actorDtoMapper.fromUserDetails(it2, avatarSize);
            map.put(t, actorDto);
        }
        return result$iv;
    }

    static /* synthetic */ Map createActorDtoMapFromAlertEntities$default(AlertDtoMapper alertDtoMapper, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 48;
        }
        return alertDtoMapper.createActorDtoMapFromAlertEntities(list, n);
    }

    /*
     * WARNING - void declaration
     */
    private final AlertDto fromAlertEntity(AlertEntity alertEntity, Map<String, ActorDto> actorMap) {
        Instant instant;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = alertEntity.getThreatEvents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ThreatEventEntity threatEventEntity = (ThreatEventEntity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MapsKt.getValue(actorMap, it.getTriggeringUserKey()));
        }
        Collection collection2 = (List)destination$iv$iv;
        String string = this.alertTypeI18nMapper.getTranslation(alertEntity.getAlertType());
        AlertSummary alertSummary = this.alertSummaryProvider.getSummary(alertEntity);
        String string2 = alertEntity.getAlertStatus().name();
        EmailStatus emailStatus = alertEntity.getEmailStatus();
        Long l = alertEntity.getId();
        Long l2 = alertEntity.getQueuedTimestamp();
        if (l2 != null) {
            void p0;
            long $this$mapTo$iv$iv2 = ((Number)l2).longValue();
            Long l3 = l;
            EmailStatus emailStatus2 = emailStatus;
            String string3 = string2;
            AlertSummary alertSummary2 = alertSummary;
            String string4 = string;
            collection = collection2;
            boolean bl = false;
            Instant instant2 = Instant.ofEpochMilli((long)p0);
            collection2 = collection;
            string = string4;
            alertSummary = alertSummary2;
            string2 = string3;
            emailStatus = emailStatus2;
            l = l3;
            instant = instant2;
        } else {
            instant = null;
        }
        Instant instant3 = alertEntity.getTimestamp();
        String string5 = alertEntity.getUuid();
        Instant instant4 = instant;
        Long l4 = l;
        EmailStatus emailStatus3 = emailStatus;
        String string6 = string2;
        AlertSummary alertSummary3 = alertSummary;
        String string7 = string;
        Collection collection3 = collection2;
        return new AlertDto((List<ActorDto>)collection3, string7, alertSummary3, string6, emailStatus3, l4, instant4, string5, instant3);
    }
}

