/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.i18n;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.notification.template.AlertSpecificTemplateParameter;
import com.atlassian.lighthouse.notification.template.TemplateParametersStrategy;
import com.atlassian.lighthouse.notification.template.parameters.AdminUserChangedValueTemplateParameters;
import com.atlassian.lighthouse.notification.template.parameters.AlertSpecificTemplateParametersProviderInterface;
import com.atlassian.lighthouse.rest.i18n.AlertDetailChangedValue;
import com.atlassian.lighthouse.rest.i18n.AlertDetailSingleValue;
import com.atlassian.lighthouse.rest.i18n.AlertSummary;
import com.atlassian.lighthouse.rest.i18n.AlertSummaryDefinition;
import com.atlassian.lighthouse.rest.i18n.DocumentationLink;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryBuilder;", "", "definition", "Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryDefinition;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "locale", "Ljava/util/Locale;", "(Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryDefinition;Lcom/atlassian/sal/api/message/I18nResolver;Lcom/atlassian/sal/api/ApplicationProperties;Ljava/util/Locale;)V", "args", "", "", "links", "", "arg", "build", "Lcom/atlassian/lighthouse/rest/i18n/AlertSummary;", "alert", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "docLink", "key", "link", "Lcom/atlassian/lighthouse/rest/i18n/DocumentationLink;", "url", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nAlertSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertSummary.kt\ncom/atlassian/lighthouse/rest/i18n/AlertSummaryBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,165:1\n1726#2,3:166\n1855#2:169\n1856#2:172\n1855#2:173\n1856#2:176\n215#3,2:170\n215#3,2:174\n*S KotlinDebug\n*F\n+ 1 AlertSummary.kt\ncom/atlassian/lighthouse/rest/i18n/AlertSummaryBuilder\n*L\n114#1:166,3\n123#1:169\n123#1:172\n139#1:173\n139#1:176\n126#1:170,2\n142#1:174,2\n*E\n"})
public final class AlertSummaryBuilder {
    @NotNull
    private final AlertSummaryDefinition definition;
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final Locale locale;
    @NotNull
    private final Map<String, String> links;
    @NotNull
    private final List<String> args;

    public AlertSummaryBuilder(@NotNull AlertSummaryDefinition definition, @NotNull I18nResolver i18nResolver, @NotNull ApplicationProperties applicationProperties, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        Intrinsics.checkNotNullParameter(locale, "locale");
        this.definition = definition;
        this.i18nResolver = i18nResolver;
        this.applicationProperties = applicationProperties;
        this.locale = locale;
        this.links = new LinkedHashMap();
        this.args = new ArrayList();
    }

    @NotNull
    public final AlertSummaryBuilder link(@NotNull String key, @Nullable String url) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.links.put(key, url);
        return this;
    }

    @NotNull
    public final AlertSummaryBuilder docLink(@NotNull String key, @NotNull DocumentationLink link) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(link, "link");
        this.links.put(key, link.toUrl(this.applicationProperties, this.locale));
        return this;
    }

    @NotNull
    public final AlertSummaryBuilder arg(@Nullable String arg) {
        this.args.add(arg);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AlertSummary build(@NotNull AlertEntity alert) {
        boolean bl;
        block12: {
            Intrinsics.checkNotNullParameter(alert, "alert");
            if (this.args.size() != this.definition.getArgCount()) {
                throw new IllegalArgumentException("Expected " + this.definition.getArgCount() + " arguments, but got " + this.args.size());
            }
            Iterable $this$all$iv = this.definition.getRequiredLinks();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (this.links.containsKey(it)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Missing required links: " + this.definition.getRequiredLinks());
        }
        AlertSpecificTemplateParametersProviderInterface templateValuesProvider = TemplateParametersStrategy.INSTANCE.getTemplateParametersProvider(alert.getAlertType());
        List changedValues = new ArrayList();
        if (Intrinsics.areEqual(templateValuesProvider, AdminUserChangedValueTemplateParameters.INSTANCE)) {
            $this$forEach$iv = alert.getThreatEvents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv;
                ThreatEventEntity threatEvent = (ThreatEventEntity)element$iv;
                boolean bl3 = false;
                Map<AlertSpecificTemplateParameter, List<String>> map = templateValuesProvider.getTemplateParameters(threatEvent.getExtraAttributes());
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry entry = element$iv2 = iterator2.next();
                    boolean bl4 = false;
                    AlertSpecificTemplateParameter key = (AlertSpecificTemplateParameter)entry.getKey();
                    List value = (List)entry.getValue();
                    if (value.size() != 2) continue;
                    String string = this.i18nResolver.getText("lighthouse.email.label." + key.getId());
                    Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                    changedValues.add(new AlertDetailChangedValue(string, (String)CollectionsKt.first(value), (String)CollectionsKt.last(value)));
                }
            }
        } else {
            $this$forEach$iv = alert.getThreatEvents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThreatEventEntity threatEvent = (ThreatEventEntity)element$iv;
                boolean bl5 = false;
                Map<AlertSpecificTemplateParameter, List<String>> $this$forEach$iv = templateValuesProvider.getTemplateParameters(threatEvent.getExtraAttributes());
                boolean $i$f$forEach3 = false;
                Iterator<Map.Entry<AlertSpecificTemplateParameter, List<String>>> iterator3 = $this$forEach$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry<AlertSpecificTemplateParameter, List<String>> element$iv3;
                    Map.Entry<AlertSpecificTemplateParameter, List<String>> entry = element$iv3 = iterator3.next();
                    boolean bl6 = false;
                    AlertSpecificTemplateParameter key = entry.getKey();
                    List<String> value = entry.getValue();
                    if (value.size() == 1) {
                        String string = this.i18nResolver.getText("lighthouse.email.label." + key.getId());
                        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                        changedValues.add(new AlertDetailSingleValue(string, CollectionsKt.first(value)));
                        continue;
                    }
                    if (value.size() != 2) continue;
                    String string = this.i18nResolver.getText("lighthouse.email.label." + key.getId());
                    Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                    changedValues.add(new AlertDetailChangedValue(string, CollectionsKt.first(value), CollectionsKt.last(value)));
                }
            }
        }
        String string = this.i18nResolver.getRawText(this.definition.getI18nKey());
        Intrinsics.checkNotNullExpressionValue(string, "getRawText(...)");
        return new AlertSummary(string, this.links, this.args, changedValues);
    }
}

