/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.security;

import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Priority(value=2000)
@Provider
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/rest/security/SystemAdminsOrSecurityGroupResourceFilter;", "Ljakarta/ws/rs/container/ContainerRequestFilter;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "(Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/lighthouse/config/system/LighthouseConfig;)V", "filter", "", "requestContext", "Ljakarta/ws/rs/container/ContainerRequestContext;", "isUserAuthorised", "", "atlassian-lighthouse-rest"})
public final class SystemAdminsOrSecurityGroupResourceFilter
implements ContainerRequestFilter {
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final LighthouseConfig lighthouseConfig;

    @Inject
    public SystemAdminsOrSecurityGroupResourceFilter(@NotNull UserManager userManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        this.userManager = userManager;
        this.lighthouseConfig = lighthouseConfig;
    }

    public void filter(@NotNull ContainerRequestContext requestContext) {
        Intrinsics.checkNotNullParameter(requestContext, "requestContext");
        if (!this.isUserAuthorised()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Client must be authenticated as an administrator or a member of the security group to access this resource.").build());
        }
    }

    private final boolean isUserAuthorised() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        Intrinsics.checkNotNull(userKey);
        UserKey userKey2 = userKey;
        return this.userManager.isSystemAdmin(userKey2) || this.userManager.isUserInGroup(userKey2, this.lighthouseConfig.getSecurityGroupName());
    }
}

