/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.detector;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditMatchingAttributes;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.ChangedValuesDetector;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.service.group.JiraGroupManagerService;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/lighthouse/security/detector/AdminChangedValuesDetector;", "Lcom/atlassian/lighthouse/security/detector/ChangedValuesDetector;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "auditEventMatchingAttributes", "Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;", "cachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "jiraGroupManagerService", "Lcom/atlassian/lighthouse/service/group/JiraGroupManagerService;", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;Lcom/atlassian/lighthouse/service/group/JiraGroupManagerService;)V", "convertAuditEntityToThreatEventEntityList", "", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "getAdminEntity", "isApplicableFor", "", "isSysAdminOrAdmin", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAdminChangedValuesDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminChangedValuesDetector.kt\ncom/atlassian/lighthouse/security/detector/AdminChangedValuesDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,39:1\n478#2,7:40\n*S KotlinDebug\n*F\n+ 1 AdminChangedValuesDetector.kt\ncom/atlassian/lighthouse/security/detector/AdminChangedValuesDetector\n*L\n35#1:40,7\n*E\n"})
public final class AdminChangedValuesDetector
extends ChangedValuesDetector {
    @NotNull
    private final AuditMatchingAttributes auditEventMatchingAttributes;
    @NotNull
    private final CachedAdminUserService cachedAdminUserService;
    @NotNull
    private final CommonDetectionFunctions commonDetectionFunctions;
    @NotNull
    private final JiraGroupManagerService jiraGroupManagerService;

    public AdminChangedValuesDetector(@NotNull AlertType alertType, @NotNull AuditMatchingAttributes auditEventMatchingAttributes, @NotNull CachedAdminUserService cachedAdminUserService, @NotNull CommonDetectionFunctions commonDetectionFunctions, @NotNull JiraGroupManagerService jiraGroupManagerService) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        Intrinsics.checkNotNullParameter(jiraGroupManagerService, "jiraGroupManagerService");
        super(alertType, auditEventMatchingAttributes, commonDetectionFunctions);
        this.auditEventMatchingAttributes = auditEventMatchingAttributes;
        this.cachedAdminUserService = cachedAdminUserService;
        this.commonDetectionFunctions = commonDetectionFunctions;
        this.jiraGroupManagerService = jiraGroupManagerService;
    }

    @Override
    public boolean isApplicableFor(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return super.isApplicableFor(auditEntity) && this.isSysAdminOrAdmin(auditEntity);
    }

    private final boolean isSysAdminOrAdmin(AuditEntity auditEntity) {
        String username = this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity).get("admin.username");
        return this.cachedAdminUserService.isUsernameInSysAdminOrAdminCache(username) || this.jiraGroupManagerService.isSysAdminOrAdmin(username);
    }

    @Override
    @NotNull
    public List<ThreatEventEntity> convertAuditEntityToThreatEventEntityList(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return CollectionsKt.plus((Collection)super.convertAuditEntityToThreatEventEntityList(auditEntity), this.getAdminEntity(auditEntity));
    }

    /*
     * WARNING - void declaration
     */
    private final ThreatEventEntity getAdminEntity(AuditEntity auditEntity) {
        void $this$filterKeys$iv;
        Map<String, String> map = this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity);
        AuditEntity auditEntity2 = auditEntity;
        CommonDetectionFunctions commonDetectionFunctions = this.commonDetectionFunctions;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!Intrinsics.areEqual(it, "admin.username")) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map2 = result$iv;
        return commonDetectionFunctions.convertAuditEntityToThreatEventEntity(auditEntity2, map2, this.commonDetectionFunctions.getUserKeyByAuditEntity(auditEntity));
    }
}

