/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.detector;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditMatchingAttributes;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.DefaultThreatDetector;
import com.atlassian.lighthouse.service.user.JiraUserManagerService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/security/detector/AdminPasswordDetector;", "Lcom/atlassian/lighthouse/security/detector/DefaultThreatDetector;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "auditEventMatchingAttributes", "Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "jiraUserManagerService", "Lcom/atlassian/lighthouse/service/user/JiraUserManagerService;", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;Lcom/atlassian/lighthouse/service/user/JiraUserManagerService;)V", "isApplicableFor", "", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "atlassian-lighthouse-core"})
public class AdminPasswordDetector
extends DefaultThreatDetector {
    @NotNull
    private final AuditMatchingAttributes auditEventMatchingAttributes;
    @NotNull
    private final JiraUserManagerService jiraUserManagerService;

    public AdminPasswordDetector(@NotNull AlertType alertType, @NotNull AuditMatchingAttributes auditEventMatchingAttributes, @NotNull CommonDetectionFunctions commonDetectionFunctions, @NotNull JiraUserManagerService jiraUserManagerService) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        Intrinsics.checkNotNullParameter(jiraUserManagerService, "jiraUserManagerService");
        super(alertType, auditEventMatchingAttributes, commonDetectionFunctions);
        this.auditEventMatchingAttributes = auditEventMatchingAttributes;
        this.jiraUserManagerService = jiraUserManagerService;
    }

    @Override
    public boolean isApplicableFor(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return super.isApplicableFor(auditEntity) && this.jiraUserManagerService.isSysAdminOrAdmin(this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity).get("admin.username"));
    }
}

