/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.detector;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditMatchingAttributes;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "(Lcom/atlassian/lighthouse/service/user/SecurityUserService;)V", "convertAuditEntityToThreatEventEntity", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "auditEventMatchingAttributes", "Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;", "extraAttributes", "", "", "userKey", "getUserKeyByAuditEntity", "getUserKeyByUserName", "userName", "isApplicableFor", "", "atlassian-lighthouse-core"})
public final class CommonDetectionFunctions {
    @NotNull
    private final SecurityUserService securityUserService;

    public CommonDetectionFunctions(@NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        this.securityUserService = securityUserService;
    }

    public final boolean isApplicableFor(@NotNull AuditEntity auditEntity, @NotNull AuditMatchingAttributes auditEventMatchingAttributes) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        return Intrinsics.areEqual(auditEntity.getAuditType().getCategoryI18nKey(), auditEventMatchingAttributes.getCategoryI18nKey()) && Intrinsics.areEqual(auditEntity.getAuditType().getActionI18nKey(), auditEventMatchingAttributes.getActionI18nKey()) && auditEventMatchingAttributes.getCustomFilter().invoke(auditEntity) != false;
    }

    @Nullable
    public final String getUserKeyByAuditEntity(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        AuditAuthor auditAuthor = auditEntity.getAuthor();
        Intrinsics.checkNotNullExpressionValue(auditAuthor, "getAuthor(...)");
        return this.securityUserService.getUserKeyByAuditAuthor(auditAuthor);
    }

    @Nullable
    public final String getUserKeyByUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        return this.securityUserService.getUserKeyByUserName(userName);
    }

    @NotNull
    public final ThreatEventEntity convertAuditEntityToThreatEventEntity(@NotNull AuditEntity auditEntity, @NotNull AuditMatchingAttributes auditEventMatchingAttributes) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        return this.convertAuditEntityToThreatEventEntity(auditEntity, auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity), this.getUserKeyByAuditEntity(auditEntity));
    }

    @NotNull
    public final ThreatEventEntity convertAuditEntityToThreatEventEntity(@NotNull AuditEntity auditEntity, @NotNull Map<String, String> extraAttributes, @Nullable String userKey) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        Intrinsics.checkNotNullParameter(extraAttributes, "extraAttributes");
        String string = auditEntity.getAuditType().getActionI18nKey();
        Intrinsics.checkNotNullExpressionValue(string, "getActionI18nKey(...)");
        String string2 = auditEntity.getMethod();
        String string3 = auditEntity.getNode();
        String string4 = auditEntity.getSource();
        String string5 = auditEntity.getSystem();
        Instant instant = auditEntity.getTimestamp();
        Intrinsics.checkNotNullExpressionValue(instant, "getTimestamp(...)");
        return new ThreatEventEntity(string, string2, extraAttributes, userKey, string3, string4, string5, instant);
    }
}

