/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.detector;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditMatchingAttributes;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.DefaultThreatDetector;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/lighthouse/security/detector/UserDeletedDetector;", "Lcom/atlassian/lighthouse/security/detector/DefaultThreatDetector;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "auditEventMatchingAttributes", "Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;", "adminUserPermissionName", "", "cachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "sysAdminUserPermissionName", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;Ljava/lang/String;Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;Ljava/lang/String;)V", "convertAuditEntityToThreatEventEntityList", "", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "getExtraAttributes", "", "isApplicableFor", "", "isSysAdminOrAdmin", "atlassian-lighthouse-core"})
public final class UserDeletedDetector
extends DefaultThreatDetector {
    @NotNull
    private final AuditMatchingAttributes auditEventMatchingAttributes;
    @NotNull
    private final String adminUserPermissionName;
    @NotNull
    private final CachedAdminUserService cachedAdminUserService;
    @NotNull
    private final CommonDetectionFunctions commonDetectionFunctions;
    @NotNull
    private final String sysAdminUserPermissionName;

    public UserDeletedDetector(@NotNull AlertType alertType, @NotNull AuditMatchingAttributes auditEventMatchingAttributes, @NotNull String adminUserPermissionName, @NotNull CachedAdminUserService cachedAdminUserService, @NotNull CommonDetectionFunctions commonDetectionFunctions, @NotNull String sysAdminUserPermissionName) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        Intrinsics.checkNotNullParameter(adminUserPermissionName, "adminUserPermissionName");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        Intrinsics.checkNotNullParameter(sysAdminUserPermissionName, "sysAdminUserPermissionName");
        super(alertType, auditEventMatchingAttributes, commonDetectionFunctions);
        this.auditEventMatchingAttributes = auditEventMatchingAttributes;
        this.adminUserPermissionName = adminUserPermissionName;
        this.cachedAdminUserService = cachedAdminUserService;
        this.commonDetectionFunctions = commonDetectionFunctions;
        this.sysAdminUserPermissionName = sysAdminUserPermissionName;
    }

    @Override
    public boolean isApplicableFor(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return super.isApplicableFor(auditEntity) && this.isSysAdminOrAdmin(auditEntity);
    }

    @Override
    @NotNull
    public List<ThreatEventEntity> convertAuditEntityToThreatEventEntityList(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        Map<String, String> extraAttributes = this.getExtraAttributes(auditEntity);
        String userKey = this.commonDetectionFunctions.getUserKeyByAuditEntity(auditEntity);
        return CollectionsKt.listOf(this.commonDetectionFunctions.convertAuditEntityToThreatEventEntity(auditEntity, extraAttributes, userKey));
    }

    private final Map<String, String> getExtraAttributes(AuditEntity auditEntity) {
        HashMap<String, String> extraAttributes = new HashMap<String, String>(this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity));
        String username = extraAttributes.get("admin.username");
        boolean isGroupNameInSysAdminCache = this.cachedAdminUserService.isUsernameInSysAdminCache(username);
        ((Map)extraAttributes).put("admin.user.permission.type", isGroupNameInSysAdminCache ? this.sysAdminUserPermissionName : this.adminUserPermissionName);
        return extraAttributes;
    }

    private final boolean isSysAdminOrAdmin(AuditEntity auditEntity) {
        String username = this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity).get("admin.username");
        return this.cachedAdminUserService.isUsernameInSysAdminOrAdminCache(username);
    }
}

